/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corefoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.GlobalValueEnumeration;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="CoreFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public class CFBundleInfoKey
extends GlobalValueEnumeration<CFString> {
    public static final CFBundleInfoKey InfoDictionaryVersion;
    public static final CFBundleInfoKey Executable;
    public static final CFBundleInfoKey Identifier;
    public static final CFBundleInfoKey Version;
    public static final CFBundleInfoKey DevelopmentRegion;
    public static final CFBundleInfoKey Name;
    public static final CFBundleInfoKey Localizations;
    private static CFBundleInfoKey[] values;

    CFBundleInfoKey(String getterName) {
        super(Values.class, getterName);
    }

    public static CFBundleInfoKey valueOf(CFString value) {
        for (CFBundleInfoKey v : values) {
            if (!((CFString)v.value()).equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + CFBundleInfoKey.class.getName());
    }

    static {
        Bro.bind(CFBundleInfoKey.class);
        InfoDictionaryVersion = new CFBundleInfoKey("InfoDictionaryVersion");
        Executable = new CFBundleInfoKey("Executable");
        Identifier = new CFBundleInfoKey("Identifier");
        Version = new CFBundleInfoKey("Version");
        DevelopmentRegion = new CFBundleInfoKey("DevelopmentRegion");
        Name = new CFBundleInfoKey("Name");
        Localizations = new CFBundleInfoKey("Localizations");
        values = new CFBundleInfoKey[]{InfoDictionaryVersion, Executable, Identifier, Version, DevelopmentRegion, Name, Localizations};
    }

    @Library(value="CoreFoundation")
    public static class Values {
        @GlobalValue(symbol="kCFBundleInfoDictionaryVersionKey", optional=true)
        public static native CFString InfoDictionaryVersion();

        @GlobalValue(symbol="kCFBundleExecutableKey", optional=true)
        public static native CFString Executable();

        @GlobalValue(symbol="kCFBundleIdentifierKey", optional=true)
        public static native CFString Identifier();

        @GlobalValue(symbol="kCFBundleVersionKey", optional=true)
        public static native CFString Version();

        @GlobalValue(symbol="kCFBundleDevelopmentRegionKey", optional=true)
        public static native CFString DevelopmentRegion();

        @GlobalValue(symbol="kCFBundleNameKey", optional=true)
        public static native CFString Name();

        @GlobalValue(symbol="kCFBundleLocalizationsKey", optional=true)
        public static native CFString Localizations();

        static {
            Bro.bind(Values.class);
        }
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<CFBundleInfoKey> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<CFBundleInfoKey> list = new ArrayList<CFBundleInfoKey>();
            int i = 0;
            while ((long)i < o.size()) {
                list.add(CFBundleInfoKey.valueOf(o.get(i, CFString.class)));
                ++i;
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<CFBundleInfoKey> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (CFBundleInfoKey i : l) {
                ((CFArray)array).add((NativeObject)i.value());
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CFBundleInfoKey toObject(Class<CFBundleInfoKey> cls, long handle, long flags) {
            CFString o = (CFString)CFType.Marshaler.toObject(CFString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return CFBundleInfoKey.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(CFBundleInfoKey o, long flags) {
            if (o == null) {
                return 0L;
            }
            return CFType.Marshaler.toNative((CFType)o.value(), flags);
        }
    }
}

