/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.Map;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSFileProtection;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreData")
public class NSPersistentStoreOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSPersistentStoreOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSPersistentStoreOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public boolean isReadOnly() {
        if (this.data.containsKey(NSPersistentStoreOptions.ReadOnlyOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.ReadOnlyOption());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setReadOnly(boolean readOnly) {
        this.data.put(NSPersistentStoreOptions.ReadOnlyOption(), NSNumber.valueOf(readOnly));
        return this;
    }

    public long getTimeout() {
        if (this.data.containsKey(NSPersistentStoreOptions.TimeoutOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.TimeoutOption());
            return val.longValue();
        }
        return 0L;
    }

    public NSPersistentStoreOptions setTimeout(long timeout) {
        this.data.put(NSPersistentStoreOptions.TimeoutOption(), NSNumber.valueOf(timeout));
        return this;
    }

    public Map<String, NSObject> getSQLitePragmas() {
        if (this.data.containsKey(NSPersistentStoreOptions.SQLitePragmasOption())) {
            NSDictionary val = (NSDictionary)this.data.get(NSPersistentStoreOptions.SQLitePragmasOption());
            return val.asStringMap();
        }
        return null;
    }

    public NSPersistentStoreOptions setSQLitePragmas(Map<String, NSObject> pragmas) {
        this.data.put(NSPersistentStoreOptions.SQLitePragmasOption(), NSDictionary.fromStringMap(pragmas));
        return this;
    }

    public boolean isSQLiteAnalyzeEnabled() {
        if (this.data.containsKey(NSPersistentStoreOptions.SQLiteAnalyzeOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.SQLiteAnalyzeOption());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setSQLiteAnalyzeEnabled(boolean enable) {
        this.data.put(NSPersistentStoreOptions.SQLiteAnalyzeOption(), NSNumber.valueOf(enable));
        return this;
    }

    public boolean isSQLiteManualVacuumEnabled() {
        if (this.data.containsKey(NSPersistentStoreOptions.SQLiteManualVacuumOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.SQLiteManualVacuumOption());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setSQLiteManualVacuumEnabled(boolean enable) {
        this.data.put(NSPersistentStoreOptions.SQLiteManualVacuumOption(), NSNumber.valueOf(enable));
        return this;
    }

    public NSFileProtection getFileProtection() {
        if (this.data.containsKey(NSPersistentStoreOptions.FileProtectionOption())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreOptions.FileProtectionOption());
            return NSFileProtection.valueOf(val);
        }
        return null;
    }

    public NSPersistentStoreOptions setFileProtection(NSFileProtection fileProtection) {
        this.data.put(NSPersistentStoreOptions.FileProtectionOption(), fileProtection.value());
        return this;
    }

    public String getUbiquitousContentName() {
        if (this.data.containsKey(NSPersistentStoreOptions.UbiquitousContentNameOption())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreOptions.UbiquitousContentNameOption());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreOptions setUbiquitousContentName(String name) {
        this.data.put(NSPersistentStoreOptions.UbiquitousContentNameOption(), new NSString(name));
        return this;
    }

    public String getUbiquitousContentURL() {
        if (this.data.containsKey(NSPersistentStoreOptions.UbiquitousContentURLOption())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreOptions.UbiquitousContentURLOption());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreOptions setUbiquitousContentURL(String url) {
        this.data.put(NSPersistentStoreOptions.UbiquitousContentURLOption(), new NSString(url));
        return this;
    }

    public String getUbiquitousPeerToken() {
        if (this.data.containsKey(NSPersistentStoreOptions.UbiquitousPeerTokenOption())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreOptions.UbiquitousPeerTokenOption());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreOptions setUbiquitousPeerToken(String peerToken) {
        this.data.put(NSPersistentStoreOptions.UbiquitousPeerTokenOption(), new NSString(peerToken));
        return this;
    }

    public boolean shouldRemoveUbiquitousMetadata() {
        if (this.data.containsKey(NSPersistentStoreOptions.RemoveUbiquitousMetadataOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.RemoveUbiquitousMetadataOption());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setShouldRemoveUbiquitousMetadata(boolean remove) {
        this.data.put(NSPersistentStoreOptions.RemoveUbiquitousMetadataOption(), NSNumber.valueOf(remove));
        return this;
    }

    public String getUbiquitousContainerIdentifier() {
        if (this.data.containsKey(NSPersistentStoreOptions.UbiquitousContainerIdentifierOption())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreOptions.UbiquitousContainerIdentifierOption());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreOptions setUbiquitousContainerIdentifier(String identifier) {
        this.data.put(NSPersistentStoreOptions.UbiquitousContainerIdentifierOption(), new NSString(identifier));
        return this;
    }

    public boolean shouldRebuildFromUbiquitousContent() {
        if (this.data.containsKey(NSPersistentStoreOptions.RebuildFromUbiquitousContentOption())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreOptions.RebuildFromUbiquitousContentOption());
            return val.booleanValue();
        }
        return false;
    }

    public NSPersistentStoreOptions setShouldRebuildFromUbiquitousContent(boolean rebuild) {
        this.data.put(NSPersistentStoreOptions.RebuildFromUbiquitousContentOption(), NSNumber.valueOf(rebuild));
        return this;
    }

    @GlobalValue(symbol="NSReadOnlyPersistentStoreOption", optional=true)
    protected static native NSString ReadOnlyOption();

    @GlobalValue(symbol="NSPersistentStoreTimeoutOption", optional=true)
    protected static native NSString TimeoutOption();

    @GlobalValue(symbol="NSSQLitePragmasOption", optional=true)
    protected static native NSString SQLitePragmasOption();

    @GlobalValue(symbol="NSSQLiteAnalyzeOption", optional=true)
    protected static native NSString SQLiteAnalyzeOption();

    @GlobalValue(symbol="NSSQLiteManualVacuumOption", optional=true)
    protected static native NSString SQLiteManualVacuumOption();

    @GlobalValue(symbol="NSIgnorePersistentStoreVersioningOption", optional=true)
    protected static native NSString IgnorePersistentStoreVersioningOption();

    @GlobalValue(symbol="NSMigratePersistentStoresAutomaticallyOption", optional=true)
    protected static native NSString MigratePersistentStoresAutomaticallyOption();

    @GlobalValue(symbol="NSInferMappingModelAutomaticallyOption", optional=true)
    protected static native NSString InferMappingModelAutomaticallyOption();

    @GlobalValue(symbol="NSPersistentStoreUbiquitousContentNameKey", optional=true)
    protected static native NSString UbiquitousContentNameOption();

    @GlobalValue(symbol="NSPersistentStoreUbiquitousContentURLKey", optional=true)
    protected static native NSString UbiquitousContentURLOption();

    @GlobalValue(symbol="NSPersistentStoreUbiquitousPeerTokenOption", optional=true)
    protected static native NSString UbiquitousPeerTokenOption();

    @GlobalValue(symbol="NSPersistentStoreRemoveUbiquitousMetadataOption", optional=true)
    protected static native NSString RemoveUbiquitousMetadataOption();

    @GlobalValue(symbol="NSPersistentStoreUbiquitousContainerIdentifierKey", optional=true)
    protected static native NSString UbiquitousContainerIdentifierOption();

    @GlobalValue(symbol="NSPersistentStoreRebuildFromUbiquitousContentOption", optional=true)
    protected static native NSString RebuildFromUbiquitousContentOption();

    @GlobalValue(symbol="NSPersistentStoreFileProtectionKey", optional=true)
    protected static native NSString FileProtectionOption();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSPersistentStoreOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSPersistentStoreOptions toObject(Class<NSPersistentStoreOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSPersistentStoreOptions(o);
        }

        @MarshalsPointer
        public static long toNative(NSPersistentStoreOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

