/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import org.robovm.apple.coredata.NSPersistentStoreType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSUUID;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreData")
public class NSPersistentStoreMetadata
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected NSPersistentStoreMetadata(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSPersistentStoreMetadata() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public String getType() {
        if (this.data.containsKey(NSPersistentStoreMetadata.TypeValue())) {
            NSString val = (NSString)this.data.get(NSPersistentStoreMetadata.TypeValue());
            return val.toString();
        }
        return null;
    }

    public NSPersistentStoreMetadata setType(NSPersistentStoreType type) {
        this.data.put(NSPersistentStoreMetadata.TypeValue(), new NSString(type.value()));
        return this;
    }

    public NSPersistentStoreMetadata setType(String type) {
        this.data.put(NSPersistentStoreMetadata.TypeValue(), new NSString(type));
        return this;
    }

    public NSUUID getUUID() {
        if (this.data.containsKey(NSPersistentStoreMetadata.UUIDValue())) {
            NSUUID val = (NSUUID)this.data.get(NSPersistentStoreMetadata.UUIDValue());
            return val;
        }
        return null;
    }

    public NSPersistentStoreMetadata setUUID(NSUUID uuid) {
        this.data.put(NSPersistentStoreMetadata.UUIDValue(), uuid);
        return this;
    }

    public NSDictionary<?, ?> getModelVersionHashes() {
        if (this.data.containsKey(NSPersistentStoreMetadata.ModelVersionHashesValue())) {
            NSDictionary val = (NSDictionary)this.data.get(NSPersistentStoreMetadata.ModelVersionHashesValue());
            return val;
        }
        return null;
    }

    public NSSet<?> getModelVersionIdentifiers() {
        if (this.data.containsKey(NSPersistentStoreMetadata.ModelVersionIdentifiersValue())) {
            NSSet val = (NSSet)this.data.get(NSPersistentStoreMetadata.ModelVersionIdentifiersValue());
            return val;
        }
        return null;
    }

    public long getOSCompatibility() {
        if (this.data.containsKey(NSPersistentStoreMetadata.OSCompatibilityValue())) {
            NSNumber val = (NSNumber)this.data.get(NSPersistentStoreMetadata.OSCompatibilityValue());
            return val.longValue();
        }
        return 0L;
    }

    @GlobalValue(symbol="NSStoreTypeKey", optional=true)
    protected static native NSString TypeValue();

    @GlobalValue(symbol="NSStoreUUIDKey", optional=true)
    protected static native NSString UUIDValue();

    @GlobalValue(symbol="NSStoreModelVersionHashesKey", optional=true)
    protected static native NSString ModelVersionHashesValue();

    @GlobalValue(symbol="NSStoreModelVersionIdentifiersKey", optional=true)
    protected static native NSString ModelVersionIdentifiersValue();

    @GlobalValue(symbol="NSPersistentStoreOSCompatibility", optional=true)
    protected static native NSString OSCompatibilityValue();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(NSPersistentStoreMetadata.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static NSPersistentStoreMetadata toObject(Class<NSPersistentStoreMetadata> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new NSPersistentStoreMetadata(o);
        }

        @MarshalsPointer
        public static long toNative(NSPersistentStoreMetadata o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

