/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.Map;
import org.robovm.apple.coredata.NSManagedObjectContext;
import org.robovm.apple.coredata.NSManagedObjectID;
import org.robovm.apple.coredata.NSManagedObjectModel;
import org.robovm.apple.coredata.NSPersistentStore;
import org.robovm.apple.coredata.NSPersistentStoreCoordinatorChangeNotificationInfo;
import org.robovm.apple.coredata.NSPersistentStoreMetadata;
import org.robovm.apple.coredata.NSPersistentStoreOptions;
import org.robovm.apple.coredata.NSPersistentStoreRequest;
import org.robovm.apple.coredata.NSPersistentStoreType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSLocking;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.objc.block.VoidBlock2;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSPersistentStoreCoordinator
extends NSObject
implements NSLocking {
    public NSPersistentStoreCoordinator() {
    }

    protected NSPersistentStoreCoordinator(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSPersistentStoreCoordinator(NSManagedObjectModel model) {
        super(null);
        this.initObject(this.init(model));
    }

    @Property(selector="managedObjectModel")
    public native NSManagedObjectModel getManagedObjectModel();

    @Property(selector="persistentStores")
    public native NSArray<NSPersistentStore> getPersistentStores();

    @Property(selector="name")
    public native String getName();

    @Property(selector="setName:")
    public native void setName(String var1);

    public NSPersistentStore addPersistentStore(NSPersistentStoreType storeType, String configuration, NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        return this.addPersistentStore(storeType.value(), configuration, storeURL, options);
    }

    public NSPersistentStore migratePersistentStore(NSPersistentStore store, NSURL URL2, NSPersistentStoreOptions options, NSPersistentStoreType storeType) throws NSErrorException {
        return this.migratePersistentStore(store, URL2, options, storeType.value());
    }

    public static void registerStoreClassForType(Class<? extends NSPersistentStore> storeClass, NSPersistentStoreType storeType) {
        NSPersistentStoreCoordinator.registerStoreClassForType(storeClass, storeType.value());
    }

    public static NSPersistentStoreMetadata getMetadataForPersistentStoreType(NSPersistentStoreType storeType, NSURL url) throws NSErrorException {
        return NSPersistentStoreCoordinator.getMetadataForPersistentStoreType(storeType.value(), url);
    }

    public static boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata metadata, NSPersistentStoreType storeType, NSURL url) throws NSErrorException {
        return NSPersistentStoreCoordinator.setMetadataForPersistentStoreType(metadata, storeType.value(), url);
    }

    @GlobalValue(symbol="NSPersistentStoreCoordinatorStoresWillChangeNotification", optional=true)
    protected static native NSString StoresWillChangeNotification();

    @GlobalValue(symbol="NSPersistentStoreCoordinatorStoresDidChangeNotification", optional=true)
    protected static native NSString StoresDidChangeNotification();

    @GlobalValue(symbol="NSPersistentStoreCoordinatorWillRemoveStoreNotification", optional=true)
    protected static native NSString WillRemoveStoreNotification();

    @GlobalValue(symbol="NSPersistentStoreDidImportUbiquitousContentChangesNotification", optional=true)
    protected static native NSString DidImportUbiquitousContentChangesNotification();

    @Method(selector="initWithManagedObjectModel:")
    @Pointer
    protected native long init(NSManagedObjectModel var1);

    @Method(selector="persistentStoreForURL:")
    public native NSPersistentStore getPersistentStoreForURL(NSURL var1);

    @Method(selector="URLForPersistentStore:")
    public native NSURL getURLForPersistentStore(NSPersistentStore var1);

    @Method(selector="setURL:forPersistentStore:")
    public native boolean setURLForPersistentStore(NSURL var1, NSPersistentStore var2);

    public NSPersistentStore addPersistentStore(String storeType, String configuration, NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStore result = this.addPersistentStore(storeType, configuration, storeURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="addPersistentStoreWithType:configuration:URL:options:error:")
    private native NSPersistentStore addPersistentStore(String var1, String var2, NSURL var3, NSPersistentStoreOptions var4, NSError.NSErrorPtr var5);

    public boolean removePersistentStore(NSPersistentStore store) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removePersistentStore(store, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removePersistentStore:error:")
    private native boolean removePersistentStore(NSPersistentStore var1, NSError.NSErrorPtr var2);

    @Method(selector="setMetadata:forPersistentStore:")
    public native void setMetadataForPersistentStore(NSPersistentStoreMetadata var1, NSPersistentStore var2);

    @Method(selector="metadataForPersistentStore:")
    public native NSDictionary<?, ?> getMetadataForPersistentStore(NSPersistentStore var1);

    @Method(selector="managedObjectIDForURIRepresentation:")
    public native NSManagedObjectID getManagedObjectIDForURIRepresentation(NSURL var1);

    public NSObject executeRequest(NSPersistentStoreRequest request, NSManagedObjectContext context) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSObject result = this.executeRequest(request, context, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="executeRequest:withContext:error:")
    private native NSObject executeRequest(NSPersistentStoreRequest var1, NSManagedObjectContext var2, NSError.NSErrorPtr var3);

    public NSPersistentStore migratePersistentStore(NSPersistentStore store, NSURL URL2, NSPersistentStoreOptions options, String storeType) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStore result = this.migratePersistentStore(store, URL2, options, storeType, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="migratePersistentStore:toURL:options:withType:error:")
    private native NSPersistentStore migratePersistentStore(NSPersistentStore var1, NSURL var2, NSPersistentStoreOptions var3, String var4, NSError.NSErrorPtr var5);

    @Method(selector="performBlock:")
    public native void performBlock(@Block Runnable var1);

    @Method(selector="performBlockAndWait:")
    public native void performBlockAndWait(@Block Runnable var1);

    @Override
    @Deprecated
    @Method(selector="lock")
    public native void lock();

    @Override
    @Deprecated
    @Method(selector="unlock")
    public native void unlock();

    @Deprecated
    @Method(selector="tryLock")
    public native boolean tryLock();

    @Method(selector="registeredStoreTypes")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public static native Map<String, NSPersistentStore> getRegisteredStoreTypes();

    @Method(selector="registerStoreClass:forStoreType:")
    public static native void registerStoreClassForType(Class<? extends NSPersistentStore> var0, String var1);

    public static NSPersistentStoreMetadata getMetadataForPersistentStoreType(String storeType, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        NSPersistentStoreMetadata result = NSPersistentStoreCoordinator.getMetadataForPersistentStoreType(storeType, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="metadataForPersistentStoreOfType:URL:error:")
    private static native NSPersistentStoreMetadata getMetadataForPersistentStoreType(String var0, NSURL var1, NSError.NSErrorPtr var2);

    public static boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata metadata, String storeType, NSURL url) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStoreCoordinator.setMetadataForPersistentStoreType(metadata, storeType, url, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="setMetadata:forPersistentStoreOfType:URL:error:")
    private static native boolean setMetadataForPersistentStoreType(NSPersistentStoreMetadata var0, String var1, NSURL var2, NSError.NSErrorPtr var3);

    public static boolean removeUbiquitousContentAndPersistentStore(NSURL storeURL, NSPersistentStoreOptions options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = NSPersistentStoreCoordinator.removeUbiquitousContentAndPersistentStore(storeURL, options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="removeUbiquitousContentAndPersistentStoreAtURL:options:error:")
    private static native boolean removeUbiquitousContentAndPersistentStore(NSURL var0, NSPersistentStoreOptions var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(NSPersistentStoreCoordinator.class);
    }

    public static class NSPersistentStoreCoordinatorPtr
    extends Ptr<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorPtr> {
    }

    public static class Notifications {
        public static NSObject observeStoresWillChange(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorChangeNotificationInfo> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSPersistentStoreCoordinator.StoresWillChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)new NSPersistentStoreCoordinatorChangeNotificationInfo(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeStoresDidChange(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSPersistentStoreCoordinatorChangeNotificationInfo> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSPersistentStoreCoordinator.StoresDidChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)new NSPersistentStoreCoordinatorChangeNotificationInfo(a.getUserInfo()));
                }
            });
        }

        public static NSObject observeWillRemoveStore(NSPersistentStoreCoordinator object, final VoidBlock1<NSPersistentStoreCoordinator> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSPersistentStoreCoordinator.WillRemoveStoreNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()));
                }
            });
        }

        public static NSObject observeDidImportUbiquitousContentChanges(NSPersistentStoreCoordinator object, final VoidBlock2<NSPersistentStoreCoordinator, NSNotification> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(NSPersistentStoreCoordinator.WillRemoveStoreNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((NSPersistentStoreCoordinator)a.getObject()), (Object)a);
                }
            });
        }
    }
}

