/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coredata;

import java.util.Map;
import org.robovm.apple.coredata.NSEntityDescription;
import org.robovm.apple.coredata.NSManagedObjectContext;
import org.robovm.apple.coredata.NSManagedObjectID;
import org.robovm.apple.coredata.NSSnapshotEventType;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSKeyValueSetMutationKind;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSSet;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="CoreData")
@NativeClass
public class NSManagedObject
extends NSObject {
    public NSManagedObject() {
    }

    protected NSManagedObject(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public NSManagedObject(NSEntityDescription entity, NSManagedObjectContext context) {
        super(null);
        this.initObject(this.init(entity, context));
    }

    @Property(selector="managedObjectContext")
    public native NSManagedObjectContext getManagedObjectContext();

    @Property(selector="entity")
    public native NSEntityDescription getEntity();

    @Property(selector="objectID")
    public native NSManagedObjectID getObjectID();

    @Property(selector="isInserted")
    public native boolean isInserted();

    @Property(selector="isUpdated")
    public native boolean isUpdated();

    @Property(selector="isDeleted")
    public native boolean isDeleted();

    @Property(selector="hasChanges")
    public native boolean hasChanges();

    @Property(selector="isFault")
    public native boolean isFault();

    @Property(selector="faultingState")
    @MachineSizedUInt
    public native long getFaultingState();

    public void setValue(String key, NSObject value) {
        this.setValue(value, key);
    }

    public void setPrimitiveValue(String key, NSObject value) {
        this.setPrimitiveValue(value, key);
    }

    public boolean validateValue(String key, NSObject value) throws NSErrorException {
        return this.validateValue(value, key);
    }

    @Method(selector="initWithEntity:insertIntoManagedObjectContext:")
    @Pointer
    protected native long init(NSEntityDescription var1, NSManagedObjectContext var2);

    @Method(selector="hasFaultForRelationshipNamed:")
    public native boolean hasFaultForRelationship(String var1);

    @Method(selector="willAccessValueForKey:")
    public native void willAccessValue(String var1);

    @Method(selector="didAccessValueForKey:")
    public native void didAccessValue(String var1);

    @Override
    @Method(selector="willChangeValueForKey:")
    public native void willChangeValue(String var1);

    @Override
    @Method(selector="didChangeValueForKey:")
    public native void didChangeValue(String var1);

    @Override
    @Method(selector="willChangeValueForKey:withSetMutation:usingObjects:")
    public native void willChangeValue(String var1, NSKeyValueSetMutationKind var2, NSSet<?> var3);

    @Override
    @Method(selector="didChangeValueForKey:withSetMutation:usingObjects:")
    public native void didChangeValue(String var1, NSKeyValueSetMutationKind var2, NSSet<?> var3);

    @Method(selector="awakeFromFetch")
    public native void awakeFromFetch();

    @Method(selector="awakeFromInsert")
    public native void awakeFromInsert();

    @Method(selector="awakeFromSnapshotEvents:")
    public native void awakeFromSnapshotEvents(NSSnapshotEventType var1);

    @Method(selector="prepareForDeletion")
    public native void prepareForDeletion();

    @Method(selector="willSave")
    public native void willSave();

    @Method(selector="didSave")
    public native void didSave();

    @Method(selector="willTurnIntoFault")
    public native void willTurnIntoFault();

    @Method(selector="didTurnIntoFault")
    public native void didTurnIntoFault();

    @Method(selector="valueForKey:")
    public native NSObject getValue(String var1);

    @Method(selector="setValue:forKey:")
    private native void setValue(NSObject var1, String var2);

    @Method(selector="primitiveValueForKey:")
    public native NSObject getPrimitiveValue(String var1);

    @Method(selector="setPrimitiveValue:forKey:")
    private native void setPrimitiveValue(NSObject var1, String var2);

    @Method(selector="committedValuesForKeys:")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSObject> getCommittedValues(NSArray<?> var1);

    @Method(selector="changedValues")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSObject> getChangedValues();

    @Method(selector="changedValuesForCurrentEvent")
    @Marshaler(value=NSDictionary.AsStringMapMarshaler.class)
    public native Map<String, NSObject> getChangedValuesForCurrentEvent();

    private boolean validateValue(NSObject value, String key) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.validateValue(value, key, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="validateValue:forKey:error:")
    private native boolean validateValue(NSObject var1, String var2, NSError.NSErrorPtr var3);

    public boolean validateForDelete() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.validateForDelete(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="validateForDelete:")
    private native boolean validateForDelete(NSError.NSErrorPtr var1);

    public boolean validateForInsert() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.validateForInsert(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="validateForInsert:")
    private native boolean validateForInsert(NSError.NSErrorPtr var1);

    public boolean validateForUpdate() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.validateForUpdate(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="validateForUpdate:")
    private native boolean validateForUpdate(NSError.NSErrorPtr var1);

    @Method(selector="contextShouldIgnoreUnmodeledPropertyChanges")
    public static native boolean shouldContextIgnoreUnmodeledPropertyChanges();

    static {
        ObjCRuntime.bind(NSManagedObject.class);
    }

    public static class NSManagedObjectPtr
    extends Ptr<NSManagedObject, NSManagedObjectPtr> {
    }
}

