/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreBluetooth")
public class CBConnectPeripheralOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CBConnectPeripheralOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public CBConnectPeripheralOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public boolean isNotifyingOnConnection() {
        if (this.data.containsKey(CBConnectPeripheralOptions.NotifyOnConnectionKey())) {
            NSNumber val = (NSNumber)this.data.get(CBConnectPeripheralOptions.NotifyOnConnectionKey());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifyOnConnection(boolean notify) {
        this.data.put(CBConnectPeripheralOptions.NotifyOnConnectionKey(), NSNumber.valueOf(notify));
        return this;
    }

    public boolean isNotifyingOnDisconnection() {
        if (this.data.containsKey(CBConnectPeripheralOptions.NotifyOnDisconnectionKey())) {
            NSNumber val = (NSNumber)this.data.get(CBConnectPeripheralOptions.NotifyOnDisconnectionKey());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifyOnDisconnection(boolean notify) {
        this.data.put(CBConnectPeripheralOptions.NotifyOnDisconnectionKey(), NSNumber.valueOf(notify));
        return this;
    }

    public boolean isNotifyingOnNotification() {
        if (this.data.containsKey(CBConnectPeripheralOptions.NotifyOnNotificationKey())) {
            NSNumber val = (NSNumber)this.data.get(CBConnectPeripheralOptions.NotifyOnNotificationKey());
            return val.booleanValue();
        }
        return false;
    }

    public CBConnectPeripheralOptions setNotifyOnNotification(boolean notify) {
        this.data.put(CBConnectPeripheralOptions.NotifyOnNotificationKey(), NSNumber.valueOf(notify));
        return this;
    }

    @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnConnectionKey", optional=true)
    protected static native NSString NotifyOnConnectionKey();

    @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnDisconnectionKey", optional=true)
    protected static native NSString NotifyOnDisconnectionKey();

    @GlobalValue(symbol="CBConnectPeripheralOptionNotifyOnNotificationKey", optional=true)
    protected static native NSString NotifyOnNotificationKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CBConnectPeripheralOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBConnectPeripheralOptions toObject(Class<CBConnectPeripheralOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBConnectPeripheralOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CBConnectPeripheralOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

