/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import org.robovm.apple.corebluetooth.CBUUID;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreBluetooth")
public class CBCentralManagerScanOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CBCentralManagerScanOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public CBCentralManagerScanOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public boolean isAllowingDuplicates() {
        if (this.data.containsKey(CBCentralManagerScanOptions.AllowDuplicatesKey())) {
            NSNumber val = (NSNumber)this.data.get(CBCentralManagerScanOptions.AllowDuplicatesKey());
            return val.booleanValue();
        }
        return false;
    }

    public CBCentralManagerScanOptions setAllowsDuplicates(boolean allowDuplicates) {
        this.data.put(CBCentralManagerScanOptions.AllowDuplicatesKey(), NSNumber.valueOf(allowDuplicates));
        return this;
    }

    public NSArray<CBUUID> getSolicitedServiceUUIDs() {
        if (this.data.containsKey(CBCentralManagerScanOptions.SolicitedServiceUUIDsKey())) {
            NSArray val = (NSArray)this.data.get(CBCentralManagerScanOptions.SolicitedServiceUUIDsKey());
            return val;
        }
        return null;
    }

    public CBCentralManagerScanOptions setSolicitedServiceUUIDs(NSArray<CBUUID> uuids) {
        this.data.put(CBCentralManagerScanOptions.SolicitedServiceUUIDsKey(), uuids);
        return this;
    }

    @GlobalValue(symbol="CBCentralManagerScanOptionAllowDuplicatesKey", optional=true)
    protected static native NSString AllowDuplicatesKey();

    @GlobalValue(symbol="CBCentralManagerScanOptionSolicitedServiceUUIDsKey", optional=true)
    protected static native NSString SolicitedServiceUUIDsKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CBCentralManagerScanOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBCentralManagerScanOptions toObject(Class<CBCentralManagerScanOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBCentralManagerScanOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CBCentralManagerScanOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

