/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import org.robovm.apple.corebluetooth.CBCentralManagerScanOptions;
import org.robovm.apple.corebluetooth.CBPeripheral;
import org.robovm.apple.corebluetooth.CBUUID;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreBluetooth")
public class CBCentralManagerRestoredState
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CBCentralManagerRestoredState(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public NSArray<CBPeripheral> getPeripherals() {
        if (this.data.containsKey(CBCentralManagerRestoredState.PeripheralsKey())) {
            NSArray val = (NSArray)this.data.get(CBCentralManagerRestoredState.PeripheralsKey());
            return val;
        }
        return null;
    }

    public NSArray<CBUUID> getScanServices() {
        if (this.data.containsKey(CBCentralManagerRestoredState.ScanServicesKey())) {
            NSArray val = (NSArray)this.data.get(CBCentralManagerRestoredState.ScanServicesKey());
            return val;
        }
        return null;
    }

    public CBCentralManagerScanOptions getScanOptions() {
        if (this.data.containsKey(CBCentralManagerRestoredState.ScanOptionsKey())) {
            NSDictionary val = (NSDictionary)this.data.get(CBCentralManagerRestoredState.ScanOptionsKey());
            return new CBCentralManagerScanOptions(val);
        }
        return null;
    }

    @GlobalValue(symbol="CBCentralManagerRestoredStatePeripheralsKey", optional=true)
    protected static native NSString PeripheralsKey();

    @GlobalValue(symbol="CBCentralManagerRestoredStateScanServicesKey", optional=true)
    protected static native NSString ScanServicesKey();

    @GlobalValue(symbol="CBCentralManagerRestoredStateScanOptionsKey", optional=true)
    protected static native NSString ScanOptionsKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CBCentralManagerRestoredState.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBCentralManagerRestoredState toObject(Class<CBCentralManagerRestoredState> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBCentralManagerRestoredState(o);
        }

        @MarshalsPointer
        public static long toNative(CBCentralManagerRestoredState o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

