/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreBluetooth")
public class CBCentralManagerOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CBCentralManagerOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public CBCentralManagerOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public boolean isShowingPowerAlert() {
        if (this.data.containsKey(CBCentralManagerOptions.ShowPowerAlertKey())) {
            NSNumber val = (NSNumber)this.data.get(CBCentralManagerOptions.ShowPowerAlertKey());
            return val.booleanValue();
        }
        return false;
    }

    public CBCentralManagerOptions setShowPowerAlert(boolean showAlert) {
        this.data.put(CBCentralManagerOptions.ShowPowerAlertKey(), NSNumber.valueOf(showAlert));
        return this;
    }

    public String getRestoreIdentifier() {
        if (this.data.containsKey(CBCentralManagerOptions.RestoreIdentifierKey())) {
            NSString val = (NSString)this.data.get(CBCentralManagerOptions.RestoreIdentifierKey());
            return val.toString();
        }
        return null;
    }

    public CBCentralManagerOptions setRestoreIdentifier(String identifier) {
        this.data.put(CBCentralManagerOptions.RestoreIdentifierKey(), new NSString(identifier));
        return this;
    }

    @GlobalValue(symbol="CBCentralManagerOptionShowPowerAlertKey", optional=true)
    protected static native NSString ShowPowerAlertKey();

    @GlobalValue(symbol="CBCentralManagerOptionRestoreIdentifierKey", optional=true)
    protected static native NSString RestoreIdentifierKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CBCentralManagerOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBCentralManagerOptions toObject(Class<CBCentralManagerOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBCentralManagerOptions(o);
        }

        @MarshalsPointer
        public static long toNative(CBCentralManagerOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

