/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.corebluetooth;

import org.robovm.apple.corebluetooth.CBUUID;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="CoreBluetooth")
public class CBAdvertisementData
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected CBAdvertisementData(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public String getLocalName() {
        if (this.data.containsKey(CBAdvertisementData.LocalNameKey())) {
            NSString val = (NSString)this.data.get(CBAdvertisementData.LocalNameKey());
            return val.toString();
        }
        return null;
    }

    public double getTxPowerLevel() {
        if (this.data.containsKey(CBAdvertisementData.TxPowerLevelKey())) {
            NSNumber val = (NSNumber)this.data.get(CBAdvertisementData.TxPowerLevelKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public NSArray<CBUUID> getServiceUUIDs() {
        if (this.data.containsKey(CBAdvertisementData.ServiceUUIDsKey())) {
            NSArray val = (NSArray)this.data.get(CBAdvertisementData.ServiceUUIDsKey());
            return val;
        }
        return null;
    }

    public NSDictionary<CBUUID, NSData> getServiceData() {
        if (this.data.containsKey(CBAdvertisementData.ServiceDataKey())) {
            NSDictionary val = (NSDictionary)this.data.get(CBAdvertisementData.ServiceDataKey());
            return val;
        }
        return null;
    }

    public NSData getManufacturerData() {
        if (this.data.containsKey(CBAdvertisementData.ManufacturerDataKey())) {
            NSData val = (NSData)this.data.get(CBAdvertisementData.ManufacturerDataKey());
            return val;
        }
        return null;
    }

    public NSArray<CBUUID> getOverflowServiceUUIDs() {
        if (this.data.containsKey(CBAdvertisementData.OverflowServiceUUIDsKey())) {
            NSArray val = (NSArray)this.data.get(CBAdvertisementData.OverflowServiceUUIDsKey());
            return val;
        }
        return null;
    }

    public boolean isConnectable() {
        if (this.data.containsKey(CBAdvertisementData.IsConnectable())) {
            NSNumber val = (NSNumber)this.data.get(CBAdvertisementData.IsConnectable());
            return val.booleanValue();
        }
        return false;
    }

    public NSArray<CBUUID> getSolicitedServiceUUIDs() {
        if (this.data.containsKey(CBAdvertisementData.SolicitedServiceUUIDsKey())) {
            NSArray val = (NSArray)this.data.get(CBAdvertisementData.SolicitedServiceUUIDsKey());
            return val;
        }
        return null;
    }

    @GlobalValue(symbol="CBAdvertisementDataLocalNameKey", optional=true)
    protected static native NSString LocalNameKey();

    @GlobalValue(symbol="CBAdvertisementDataTxPowerLevelKey", optional=true)
    protected static native NSString TxPowerLevelKey();

    @GlobalValue(symbol="CBAdvertisementDataServiceUUIDsKey", optional=true)
    protected static native NSString ServiceUUIDsKey();

    @GlobalValue(symbol="CBAdvertisementDataServiceDataKey", optional=true)
    protected static native NSString ServiceDataKey();

    @GlobalValue(symbol="CBAdvertisementDataManufacturerDataKey", optional=true)
    protected static native NSString ManufacturerDataKey();

    @GlobalValue(symbol="CBAdvertisementDataOverflowServiceUUIDsKey", optional=true)
    protected static native NSString OverflowServiceUUIDsKey();

    @GlobalValue(symbol="CBAdvertisementDataIsConnectable", optional=true)
    protected static native NSString IsConnectable();

    @GlobalValue(symbol="CBAdvertisementDataSolicitedServiceUUIDsKey", optional=true)
    protected static native NSString SolicitedServiceUUIDsKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(CBAdvertisementData.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static CBAdvertisementData toObject(Class<CBAdvertisementData> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new CBAdvertisementData(o);
        }

        @MarshalsPointer
        public static long toNative(CBAdvertisementData o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

