/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreaudio;

import org.robovm.apple.coreaudio.AudioChannelBits;
import org.robovm.apple.coreaudio.AudioChannelDescription;
import org.robovm.apple.coreaudio.AudioChannelLayoutTag;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioChannelLayout
extends Struct<AudioChannelLayout> {
    public AudioChannelLayout() {
    }

    public AudioChannelLayout(AudioChannelLayoutTag channelLayoutTag, AudioChannelBits channelBitmap) {
        this.setChannelLayoutTag(channelLayoutTag);
        this.setChannelBitmap(channelBitmap);
    }

    public int getChannelDescriptionCount() {
        return this.getNumberChannelDescriptions();
    }

    public AudioChannelDescription getChannelDescription(int index) {
        if (index >= this.getNumberChannelDescriptions()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (AudioChannelDescription)((AudioChannelDescription.AudioChannelDescriptionPtr)this.getChannelDescriptions0().next(index)).get();
    }

    public AudioChannelLayout setChannelDescription(int index, AudioChannelDescription value) {
        if (index >= this.getNumberChannelDescriptions()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((AudioChannelDescription.AudioChannelDescriptionPtr)this.getChannelDescriptions0().next(index)).set((NativeObject)value);
        return this;
    }

    public AudioChannelDescription[] getChannelDescriptions() {
        int count = this.getChannelDescriptionCount();
        AudioChannelDescription[] array = new AudioChannelDescription[count];
        AudioChannelDescription.AudioChannelDescriptionPtr ptr = this.getChannelDescriptions0();
        for (int i = 0; i < count; ++i) {
            array[i] = (AudioChannelDescription)((AudioChannelDescription.AudioChannelDescriptionPtr)ptr.next(i)).get();
        }
        return array;
    }

    public AudioChannelLayout setChannelDescriptions(AudioChannelDescription[] channelDescriptions) {
        this.setNumberChannelDescriptions(channelDescriptions.length);
        this.getChannelDescriptions0().set((NativeObject[])channelDescriptions);
        return this;
    }

    @StructMember(value=0)
    public native AudioChannelLayoutTag getChannelLayoutTag();

    @StructMember(value=0)
    public native AudioChannelLayout setChannelLayoutTag(AudioChannelLayoutTag var1);

    @StructMember(value=1)
    public native AudioChannelBits getChannelBitmap();

    @StructMember(value=1)
    public native AudioChannelLayout setChannelBitmap(AudioChannelBits var1);

    @StructMember(value=2)
    protected native int getNumberChannelDescriptions();

    @StructMember(value=2)
    protected native AudioChannelLayout setNumberChannelDescriptions(int var1);

    @StructMember(value=3)
    protected native AudioChannelDescription.AudioChannelDescriptionPtr getChannelDescriptions0();

    @StructMember(value=3)
    protected native AudioChannelLayout setChannelDescriptions0(AudioChannelDescription.AudioChannelDescriptionPtr var1);

    public static class AudioChannelLayoutPtr
    extends Ptr<AudioChannelLayout, AudioChannelLayoutPtr> {
    }
}

