/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreaudio;

import org.robovm.apple.coreaudio.AudioBuffer;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.StructMember;
import org.robovm.rt.bro.ptr.Ptr;

public class AudioBufferList
extends Struct<AudioBufferList> {
    public int getBufferCount() {
        return this.getNumberBuffers();
    }

    public AudioBuffer getBuffer(int index) {
        if (index >= this.getBufferCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (AudioBuffer)((AudioBuffer.AudioBufferPtr)this.getBuffers0().next(index)).get();
    }

    public AudioBufferList setBuffer(int index, AudioBuffer buffer) {
        return this.setBuffer(index, buffer.getHandle());
    }

    public AudioBufferList setBuffer(int index, long handle) {
        if (index >= this.getBufferCount()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        ((AudioBuffer.AudioBufferPtr)this.getBuffers0().next(index)).set(handle);
        return this;
    }

    public AudioBuffer[] getBuffers() {
        int count = this.getBufferCount();
        AudioBuffer[] array = new AudioBuffer[count];
        AudioBuffer.AudioBufferPtr ptr = this.getBuffers0();
        for (int i = 0; i < count; ++i) {
            array[i] = (AudioBuffer)((AudioBuffer.AudioBufferPtr)ptr.next(i)).get();
        }
        return array;
    }

    public AudioBufferList setBuffers(AudioBuffer[] buffers) {
        this.setNumberBuffers(buffers.length);
        this.getBuffers0().set((NativeObject[])buffers);
        return this;
    }

    @StructMember(value=0)
    protected native int getNumberBuffers();

    @StructMember(value=0)
    protected native AudioBufferList setNumberBuffers(int var1);

    @StructMember(value=1)
    protected native AudioBuffer.AudioBufferPtr getBuffers0();

    @StructMember(value=1)
    protected native AudioBufferList setBuffers0(AudioBuffer.AudioBufferPtr var1);

    public static class AudioBufferListPtr
    extends Ptr<AudioBufferList, AudioBufferListPtr> {
    }
}

