/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreanimation;

import org.robovm.apple.coreanimation.CALayer;
import org.robovm.apple.coreanimation.CATextAlignmentMode;
import org.robovm.apple.coreanimation.CATextTruncationMode;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGColor;
import org.robovm.apple.coregraphics.CGFont;
import org.robovm.apple.coretext.CTFont;
import org.robovm.apple.foundation.NSAttributedString;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedFloat;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="QuartzCore")
@NativeClass
public class CATextLayer
extends CALayer {
    public CATextLayer() {
    }

    protected CATextLayer(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="string")
    @Pointer
    protected native long getStringPtr();

    @Property(selector="setString:")
    protected native void setStringPtr(@Pointer long var1);

    @Property(selector="font")
    @Pointer
    protected native long getFontPtr();

    @Property(selector="setFont:")
    protected native void setFontPtr(@Pointer long var1);

    @Property(selector="fontSize")
    @MachineSizedFloat
    public native double getFontSize();

    @Property(selector="setFontSize:")
    public native void setFontSize(@MachineSizedFloat double var1);

    @Property(selector="foregroundColor")
    public native CGColor getForegroundColor();

    @Property(selector="setForegroundColor:")
    public native void setForegroundColor(CGColor var1);

    @Property(selector="isWrapped")
    public native boolean isWrapped();

    @Property(selector="setWrapped:")
    public native void setWrapped(boolean var1);

    @Property(selector="truncationMode")
    public native CATextTruncationMode getTruncationMode();

    @Property(selector="setTruncationMode:")
    public native void setTruncationMode(CATextTruncationMode var1);

    @Property(selector="alignmentMode")
    public native CATextAlignmentMode getAlignmentMode();

    @Property(selector="setAlignmentMode:")
    public native void setAlignmentMode(CATextAlignmentMode var1);

    public Object getString() {
        long ptr = this.getStringPtr();
        if (ptr == 0L) {
            return null;
        }
        NSObject obj = NSObject.Marshaler.toObject(NSObject.class, ptr, 0L);
        if (obj instanceof NSString) {
            return obj.toString();
        }
        return obj;
    }

    public void setString(String string) {
        this.setStringPtr(new NSString(string).getHandle());
    }

    public void setString(NSAttributedString string) {
        this.setStringPtr(string.getHandle());
    }

    public Object getFont() {
        long ptr = this.getFontPtr();
        if (ptr == 0L) {
            return null;
        }
        CFType cfObj = CFType.Marshaler.toObject(CFType.class, ptr, 0L);
        if (cfObj instanceof CFString) {
            return cfObj.toString();
        }
        return cfObj;
    }

    public void setFont(CTFont font) {
        this.setFontPtr(font.getHandle());
    }

    public void setFont(CGFont font) {
        this.setFontPtr(font.getHandle());
    }

    public void setFont(String font) {
        this.setFontPtr(new NSString(font).getHandle());
    }

    static {
        ObjCRuntime.bind(CATextLayer.class);
    }

    public static class CATextLayerPtr
    extends Ptr<CATextLayer, CATextLayerPtr> {
    }
}

