/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.coreanimation;

import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.Selector;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="QuartzCore")
@NativeClass
public class CADisplayLink
extends NSObject {
    private static final String LISTENER_KEY = "listener";
    private static final Selector handleUpdate = Selector.register((String)"handleUpdate");

    protected CADisplayLink(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="timestamp")
    public native double getTimestamp();

    @Property(selector="duration")
    public native double getDuration();

    @Property(selector="isPaused")
    public native boolean isPaused();

    @Property(selector="setPaused:")
    public native void setPaused(boolean var1);

    @Property(selector="frameInterval")
    @MachineSizedSInt
    public native long getFrameInterval();

    @Property(selector="setFrameInterval:")
    public native void setFrameInterval(@MachineSizedSInt long var1);

    public void addToRunLoop(NSRunLoop runloop, NSRunLoopMode mode) {
        this.addToRunLoop(runloop, mode.value());
    }

    public void removeFromRunLoop(NSRunLoop runloop, NSRunLoopMode mode) {
        this.removeFromRunLoop(runloop, mode.value());
    }

    public static CADisplayLink create(OnUpdateListener listener) {
        if (listener == null) {
            throw new NullPointerException(LISTENER_KEY);
        }
        ListenerWrapper l = new ListenerWrapper(listener);
        CADisplayLink result = CADisplayLink.create(l, handleUpdate);
        result.setAssociatedObject(LISTENER_KEY, l);
        return result;
    }

    protected void dispose(boolean finalizing) {
        this.setAssociatedObject(LISTENER_KEY, null);
        super.dispose(finalizing);
    }

    @Method(selector="addToRunLoop:forMode:")
    public native void addToRunLoop(NSRunLoop var1, String var2);

    @Method(selector="removeFromRunLoop:forMode:")
    public native void removeFromRunLoop(NSRunLoop var1, String var2);

    @Method(selector="invalidate")
    public native void invalidate();

    @Method(selector="displayLinkWithTarget:selector:")
    public static native CADisplayLink create(NSObject var0, Selector var1);

    static {
        ObjCRuntime.bind(CADisplayLink.class);
    }

    public static class CADisplayLinkPtr
    extends Ptr<CADisplayLink, CADisplayLinkPtr> {
    }

    private static class ListenerWrapper
    extends NSObject {
        private final OnUpdateListener listener;

        private ListenerWrapper(OnUpdateListener listener) {
            this.listener = listener;
        }

        @Method(selector="handleUpdate")
        private void handleUpdate(CADisplayLink displayLink) {
            this.listener.onUpdate(displayLink);
        }
    }

    public static interface OnUpdateListener {
        public void onUpdate(CADisplayLink var1);
    }
}

