/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.cloudkit;

import org.robovm.apple.cloudkit.CKErrorCode;
import org.robovm.apple.cloudkit.CKErrorUserInfoKey;
import org.robovm.apple.cloudkit.CKRecord;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorUserInfo;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="CloudKit")
public class CKError
extends NSError {
    protected CKError(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Override
    public CKErrorCode getErrorCode() {
        CKErrorCode code = null;
        try {
            code = CKErrorCode.valueOf(this.getCode());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return code;
    }

    public NSDictionary<?, ?> getPartialErrors() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(CKErrorUserInfoKey.PartialErrorsByItemID)) {
            NSDictionary val = (NSDictionary)data.get(CKErrorUserInfoKey.PartialErrorsByItemID);
            return val;
        }
        return null;
    }

    public CKRecord getAncestorRecord() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(CKErrorUserInfoKey.AncestorRecord)) {
            CKRecord val = (CKRecord)data.get(CKErrorUserInfoKey.AncestorRecord);
            return val;
        }
        return null;
    }

    public CKRecord getServerRecord() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(CKErrorUserInfoKey.ServerRecord)) {
            CKRecord val = (CKRecord)data.get(CKErrorUserInfoKey.ServerRecord);
            return val;
        }
        return null;
    }

    public CKRecord getClientRecord() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(CKErrorUserInfoKey.ClientRecord)) {
            CKRecord val = (CKRecord)data.get(CKErrorUserInfoKey.ClientRecord);
            return val;
        }
        return null;
    }

    public double getRetryAfterTime() {
        NSErrorUserInfo data = this.getUserInfo();
        if (data.contains(CKErrorUserInfoKey.RetryAfter)) {
            NSNumber val = (NSNumber)data.get(CKErrorUserInfoKey.RetryAfter);
            return val.doubleValue();
        }
        return -1.0;
    }

    @GlobalValue(symbol="CKErrorDomain", optional=true)
    public static native String getClassDomain();

    static {
        Bro.bind(CKError.class);
    }
}

