/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVVideoCleanAperture;
import org.robovm.apple.avfoundation.AVVideoCompressionSettings;
import org.robovm.apple.avfoundation.AVVideoH264EntropyMode;
import org.robovm.apple.avfoundation.AVVideoProfileLevel;
import org.robovm.apple.avfoundation.AVVideoScalingMode;
import org.robovm.apple.coremedia.CMVideoCodecType;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVVideoSettings
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVVideoSettings(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVVideoSettings() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public CMVideoCodecType getCodec() {
        if (this.data.containsKey(AVVideoSettings.CodecKey())) {
            NSString val = (NSString)this.data.get(AVVideoSettings.CodecKey());
            return CMVideoCodecType.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setCodec(CMVideoCodecType codec) {
        this.data.put(AVVideoSettings.CodecKey(), new NSString(codec.asFourCharCode()));
        return this;
    }

    public long getWidth() {
        if (this.data.containsKey(AVVideoSettings.WidthKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoSettings.WidthKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoSettings setWidth(long width) {
        this.data.put(AVVideoSettings.WidthKey(), NSNumber.valueOf(width));
        return this;
    }

    public long getHeight() {
        if (this.data.containsKey(AVVideoSettings.HeightKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoSettings.HeightKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoSettings setHeight(long height) {
        this.data.put(AVVideoSettings.HeightKey(), NSNumber.valueOf(height));
        return this;
    }

    public double getPixelAspectRatioHorizontalSpacing() {
        NSDictionary val;
        if (this.data.containsKey(AVVideoSettings.PixelAspectRatioKey()) && (val = (NSDictionary)this.data.get(AVVideoSettings.PixelAspectRatioKey())).containsKey(AVVideoSettings.PixelAspectRatioHorizontalSpacingKey())) {
            NSNumber n = (NSNumber)val.get(AVVideoSettings.PixelAspectRatioHorizontalSpacingKey());
            return n.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setPixelAspectRatioHorizontalSpacing(double spacing) {
        NSDictionary val = null;
        val = this.data.containsKey(AVVideoSettings.PixelAspectRatioKey()) ? (NSDictionary)this.data.get(AVVideoSettings.PixelAspectRatioKey()) : new NSMutableDictionary<NSString, NSNumber>();
        ((NSDictionary)val).put(AVVideoSettings.PixelAspectRatioHorizontalSpacingKey(), NSNumber.valueOf(spacing));
        this.data.put(AVVideoSettings.PixelAspectRatioKey(), val);
        return this;
    }

    public double getPixelAspectRatioVerticalSpacing() {
        NSDictionary val;
        if (this.data.containsKey(AVVideoSettings.PixelAspectRatioKey()) && (val = (NSDictionary)this.data.get(AVVideoSettings.PixelAspectRatioKey())).containsKey(AVVideoSettings.PixelAspectRatioVerticalSpacingKey())) {
            NSNumber n = (NSNumber)val.get(AVVideoSettings.PixelAspectRatioVerticalSpacingKey());
            return n.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setPixelAspectRatioVerticalSpacing(double spacing) {
        NSDictionary val = null;
        val = this.data.containsKey(AVVideoSettings.PixelAspectRatioKey()) ? (NSDictionary)this.data.get(AVVideoSettings.PixelAspectRatioKey()) : new NSMutableDictionary<NSString, NSNumber>();
        ((NSDictionary)val).put(AVVideoSettings.PixelAspectRatioVerticalSpacingKey(), NSNumber.valueOf(spacing));
        this.data.put(AVVideoSettings.PixelAspectRatioKey(), val);
        return this;
    }

    public AVVideoCleanAperture getCleanAperture() {
        if (this.data.containsKey(AVVideoSettings.CleanApertureKey())) {
            NSDictionary val = (NSDictionary)this.data.get(AVVideoSettings.CleanApertureKey());
            return new AVVideoCleanAperture(val);
        }
        return null;
    }

    public AVVideoSettings setCleanAperture(AVVideoCleanAperture cleanAperture) {
        this.data.put(AVVideoSettings.CleanApertureKey(), cleanAperture.getDictionary());
        return this;
    }

    public AVVideoScalingMode getScalingMode() {
        if (this.data.containsKey(AVVideoSettings.ScalingModeKey())) {
            NSString val = (NSString)this.data.get(AVVideoSettings.ScalingModeKey());
            return AVVideoScalingMode.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setScalingMode(AVVideoScalingMode scalingMode) {
        this.data.put(AVVideoSettings.ScalingModeKey(), scalingMode.value());
        return this;
    }

    public AVVideoCompressionSettings getCompressionSettings() {
        if (this.data.containsKey(AVVideoSettings.CompressionPropertiesKey())) {
            NSDictionary val = (NSDictionary)this.data.get(AVVideoSettings.CompressionPropertiesKey());
            return new AVVideoCompressionSettings(val);
        }
        return null;
    }

    public AVVideoSettings setCompressionSettings(AVVideoCompressionSettings settings) {
        this.data.put(AVVideoSettings.CompressionPropertiesKey(), settings.getDictionary());
        return this;
    }

    public boolean allowsFrameReordering() {
        if (this.data.containsKey(AVVideoSettings.AllowFrameReorderingKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoSettings.AllowFrameReorderingKey());
            return val.booleanValue();
        }
        return false;
    }

    public AVVideoSettings setAllowsFrameReordering(boolean frameReordering) {
        this.data.put(AVVideoSettings.AllowFrameReorderingKey(), NSNumber.valueOf(frameReordering));
        return this;
    }

    public AVVideoProfileLevel getProfileLevel() {
        if (this.data.containsKey(AVVideoSettings.ProfileLevelKey())) {
            NSString val = (NSString)this.data.get(AVVideoSettings.ProfileLevelKey());
            return AVVideoProfileLevel.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setProfileLevel(AVVideoProfileLevel profileLevel) {
        this.data.put(AVVideoSettings.ProfileLevelKey(), profileLevel.value());
        return this;
    }

    public AVVideoH264EntropyMode getH264EntropyMode() {
        if (this.data.containsKey(AVVideoSettings.H264EntropyModeKey())) {
            NSString val = (NSString)this.data.get(AVVideoSettings.H264EntropyModeKey());
            return AVVideoH264EntropyMode.valueOf(val);
        }
        return null;
    }

    public AVVideoSettings setH264EntropyMode(AVVideoH264EntropyMode mode) {
        this.data.put(AVVideoSettings.H264EntropyModeKey(), mode.value());
        return this;
    }

    public double getExpectedSourceFrameRate() {
        if (this.data.containsKey(AVVideoSettings.ExpectedSourceFrameRateKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoSettings.ExpectedSourceFrameRateKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setExpectedSourceFrameRate(double frameRate) {
        this.data.put(AVVideoSettings.ExpectedSourceFrameRateKey(), NSNumber.valueOf(frameRate));
        return this;
    }

    public double getAverageNonDroppableFrameRate() {
        if (this.data.containsKey(AVVideoSettings.AverageNonDroppableFrameRateKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoSettings.AverageNonDroppableFrameRateKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoSettings setAverageNonDroppableFrameRate(double frameRate) {
        this.data.put(AVVideoSettings.AverageNonDroppableFrameRateKey(), NSNumber.valueOf(frameRate));
        return this;
    }

    @GlobalValue(symbol="AVVideoCodecKey", optional=true)
    protected static native NSString CodecKey();

    @GlobalValue(symbol="AVVideoWidthKey", optional=true)
    protected static native NSString WidthKey();

    @GlobalValue(symbol="AVVideoHeightKey", optional=true)
    protected static native NSString HeightKey();

    @GlobalValue(symbol="AVVideoPixelAspectRatioKey", optional=true)
    protected static native NSString PixelAspectRatioKey();

    @GlobalValue(symbol="AVVideoPixelAspectRatioHorizontalSpacingKey", optional=true)
    protected static native NSString PixelAspectRatioHorizontalSpacingKey();

    @GlobalValue(symbol="AVVideoPixelAspectRatioVerticalSpacingKey", optional=true)
    protected static native NSString PixelAspectRatioVerticalSpacingKey();

    @GlobalValue(symbol="AVVideoCleanApertureKey", optional=true)
    protected static native NSString CleanApertureKey();

    @GlobalValue(symbol="AVVideoScalingModeKey", optional=true)
    protected static native NSString ScalingModeKey();

    @GlobalValue(symbol="AVVideoCompressionPropertiesKey", optional=true)
    protected static native NSString CompressionPropertiesKey();

    @GlobalValue(symbol="AVVideoAllowFrameReorderingKey", optional=true)
    protected static native NSString AllowFrameReorderingKey();

    @GlobalValue(symbol="AVVideoProfileLevelKey", optional=true)
    protected static native NSString ProfileLevelKey();

    @GlobalValue(symbol="AVVideoH264EntropyModeKey", optional=true)
    protected static native NSString H264EntropyModeKey();

    @GlobalValue(symbol="AVVideoExpectedSourceFrameRateKey", optional=true)
    protected static native NSString ExpectedSourceFrameRateKey();

    @GlobalValue(symbol="AVVideoAverageNonDroppableFrameRateKey", optional=true)
    protected static native NSString AverageNonDroppableFrameRateKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVVideoSettings.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVVideoSettings toObject(Class<AVVideoSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVVideoSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVVideoSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

