/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVVideoCompressionSettings
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVVideoCompressionSettings(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVVideoCompressionSettings() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public double getAverageBitRate() {
        if (this.data.containsKey(AVVideoCompressionSettings.AverageBitRateKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCompressionSettings.AverageBitRateKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setAverageBitRate(double bitRate) {
        this.data.put(AVVideoCompressionSettings.AverageBitRateKey(), NSNumber.valueOf(bitRate));
        return this;
    }

    public double getQuality() {
        if (this.data.containsKey(AVVideoCompressionSettings.QualityKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCompressionSettings.QualityKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setQuality(double quality) {
        this.data.put(AVVideoCompressionSettings.QualityKey(), NSNumber.valueOf(quality));
        return this;
    }

    public double getMaxKeyFrameInterval() {
        if (this.data.containsKey(AVVideoCompressionSettings.MaxKeyFrameIntervalKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCompressionSettings.MaxKeyFrameIntervalKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setMaxKeyFrameInterval(double interval) {
        this.data.put(AVVideoCompressionSettings.MaxKeyFrameIntervalKey(), NSNumber.valueOf(interval));
        return this;
    }

    public double getMaxKeyFrameIntervalDuration() {
        if (this.data.containsKey(AVVideoCompressionSettings.MaxKeyFrameIntervalDurationKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCompressionSettings.MaxKeyFrameIntervalDurationKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVVideoCompressionSettings setMaxKeyFrameIntervalDuration(double duration) {
        this.data.put(AVVideoCompressionSettings.MaxKeyFrameIntervalDurationKey(), NSNumber.valueOf(duration));
        return this;
    }

    @GlobalValue(symbol="AVVideoAverageBitRateKey", optional=true)
    protected static native NSString AverageBitRateKey();

    @GlobalValue(symbol="AVVideoQualityKey", optional=true)
    protected static native NSString QualityKey();

    @GlobalValue(symbol="AVVideoMaxKeyFrameIntervalKey", optional=true)
    protected static native NSString MaxKeyFrameIntervalKey();

    @GlobalValue(symbol="AVVideoMaxKeyFrameIntervalDurationKey", optional=true)
    protected static native NSString MaxKeyFrameIntervalDurationKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVVideoCompressionSettings.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVVideoCompressionSettings toObject(Class<AVVideoCompressionSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVVideoCompressionSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVVideoCompressionSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

