/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVVideoCleanAperture
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVVideoCleanAperture(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVVideoCleanAperture() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public long getWidth() {
        if (this.data.containsKey(AVVideoCleanAperture.WidthKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCleanAperture.WidthKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoCleanAperture setWidth(long width) {
        this.data.put(AVVideoCleanAperture.WidthKey(), NSNumber.valueOf(width));
        return this;
    }

    public long getHeight() {
        if (this.data.containsKey(AVVideoCleanAperture.HeightKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCleanAperture.HeightKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoCleanAperture setHeight(long height) {
        this.data.put(AVVideoCleanAperture.HeightKey(), NSNumber.valueOf(height));
        return this;
    }

    public long getHorizontalOffset() {
        if (this.data.containsKey(AVVideoCleanAperture.HorizontalOffsetKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCleanAperture.HorizontalOffsetKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoCleanAperture setHorizontalOffset(long offset) {
        this.data.put(AVVideoCleanAperture.HorizontalOffsetKey(), NSNumber.valueOf(offset));
        return this;
    }

    public long getVerticalOffset() {
        if (this.data.containsKey(AVVideoCleanAperture.VerticalOffsetKey())) {
            NSNumber val = (NSNumber)this.data.get(AVVideoCleanAperture.VerticalOffsetKey());
            return val.longValue();
        }
        return 0L;
    }

    public AVVideoCleanAperture setVerticalOffset(long offset) {
        this.data.put(AVVideoCleanAperture.VerticalOffsetKey(), NSNumber.valueOf(offset));
        return this;
    }

    @GlobalValue(symbol="AVVideoCleanApertureWidthKey", optional=true)
    protected static native NSString WidthKey();

    @GlobalValue(symbol="AVVideoCleanApertureHeightKey", optional=true)
    protected static native NSString HeightKey();

    @GlobalValue(symbol="AVVideoCleanApertureHorizontalOffsetKey", optional=true)
    protected static native NSString HorizontalOffsetKey();

    @GlobalValue(symbol="AVVideoCleanApertureVerticalOffsetKey", optional=true)
    protected static native NSString VerticalOffsetKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVVideoCleanAperture.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVVideoCleanAperture toObject(Class<AVVideoCleanAperture> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVVideoCleanAperture(o);
        }

        @MarshalsPointer
        public static long toNative(AVVideoCleanAperture o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

