/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAssetReferenceRestrictions;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSHTTPCookie;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVURLAssetOptions
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVURLAssetOptions(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVURLAssetOptions() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public boolean prefersPreciseDurationAndTiming() {
        if (this.data.containsKey(AVURLAssetOptions.PreferPreciseDurationAndTimingKey())) {
            NSNumber val = (NSNumber)this.data.get(AVURLAssetOptions.PreferPreciseDurationAndTimingKey());
            return val.booleanValue();
        }
        return false;
    }

    public AVURLAssetOptions setPrefersPreciseDurationAndTiming(boolean preferPrecise) {
        this.data.put(AVURLAssetOptions.PreferPreciseDurationAndTimingKey(), NSNumber.valueOf(preferPrecise));
        return this;
    }

    public AVAssetReferenceRestrictions getReferenceRestrictions() {
        if (this.data.containsKey(AVURLAssetOptions.ReferenceRestrictionsKey())) {
            NSNumber val = (NSNumber)this.data.get(AVURLAssetOptions.ReferenceRestrictionsKey());
            return new AVAssetReferenceRestrictions(val.longValue());
        }
        return null;
    }

    public AVURLAssetOptions setReferenceRestrictions(AVAssetReferenceRestrictions restrictions) {
        this.data.put(AVURLAssetOptions.ReferenceRestrictionsKey(), NSNumber.valueOf(restrictions.value()));
        return this;
    }

    public NSArray<NSHTTPCookie> getHTTPCookies() {
        if (this.data.containsKey(AVURLAssetOptions.HTTPCookiesKey())) {
            NSArray val = (NSArray)this.data.get(AVURLAssetOptions.HTTPCookiesKey());
            return val;
        }
        return null;
    }

    public AVURLAssetOptions setHTTPCookies(NSArray<NSHTTPCookie> cookies) {
        this.data.put(AVURLAssetOptions.HTTPCookiesKey(), cookies);
        return this;
    }

    @GlobalValue(symbol="AVURLAssetPreferPreciseDurationAndTimingKey", optional=true)
    protected static native NSString PreferPreciseDurationAndTimingKey();

    @GlobalValue(symbol="AVURLAssetReferenceRestrictionsKey", optional=true)
    protected static native NSString ReferenceRestrictionsKey();

    @GlobalValue(symbol="AVURLAssetHTTPCookiesKey", optional=true)
    protected static native NSString HTTPCookiesKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVURLAssetOptions.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVURLAssetOptions toObject(Class<AVURLAssetOptions> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVURLAssetOptions(o);
        }

        @MarshalsPointer
        public static long toNative(AVURLAssetOptions o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

