/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVTrackAssociationType
extends CocoaUtility {
    public static final AVTrackAssociationType AudioFallback;
    public static final AVTrackAssociationType ChapterList;
    public static final AVTrackAssociationType ForcedSubtitlesOnly;
    public static final AVTrackAssociationType SelectionFollower;
    public static final AVTrackAssociationType Timecode;
    public static final AVTrackAssociationType MetadataReferent;
    private static AVTrackAssociationType[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVTrackAssociationType(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVTrackAssociationType valueOf(NSString value) {
        for (AVTrackAssociationType v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVTrackAssociationType.class.getName());
    }

    @GlobalValue(symbol="AVTrackAssociationTypeAudioFallback", optional=true)
    protected static native NSString AudioFallbackValue();

    @GlobalValue(symbol="AVTrackAssociationTypeChapterList", optional=true)
    protected static native NSString ChapterListValue();

    @GlobalValue(symbol="AVTrackAssociationTypeForcedSubtitlesOnly", optional=true)
    protected static native NSString ForcedSubtitlesOnlyValue();

    @GlobalValue(symbol="AVTrackAssociationTypeSelectionFollower", optional=true)
    protected static native NSString SelectionFollowerValue();

    @GlobalValue(symbol="AVTrackAssociationTypeTimecode", optional=true)
    protected static native NSString TimecodeValue();

    @GlobalValue(symbol="AVTrackAssociationTypeMetadataReferent", optional=true)
    protected static native NSString MetadataReferentValue();

    static {
        Bro.bind(AVTrackAssociationType.class);
        AudioFallback = new AVTrackAssociationType("AudioFallbackValue");
        ChapterList = new AVTrackAssociationType("ChapterListValue");
        ForcedSubtitlesOnly = new AVTrackAssociationType("ForcedSubtitlesOnlyValue");
        SelectionFollower = new AVTrackAssociationType("SelectionFollowerValue");
        Timecode = new AVTrackAssociationType("TimecodeValue");
        MetadataReferent = new AVTrackAssociationType("MetadataReferentValue");
        values = new AVTrackAssociationType[]{AudioFallback, ChapterList, ForcedSubtitlesOnly, SelectionFollower, Timecode, MetadataReferent};
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVTrackAssociationType> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVTrackAssociationType> list = new ArrayList<AVTrackAssociationType>();
            for (NSString str : o) {
                list.add(AVTrackAssociationType.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVTrackAssociationType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVTrackAssociationType i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVTrackAssociationType toObject(Class<AVTrackAssociationType> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVTrackAssociationType.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVTrackAssociationType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

