/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioQuality;
import org.robovm.apple.avfoundation.AVSampleRateConverterAlgorithm;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVSampleRateConverterSettings
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVSampleRateConverterSettings(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVSampleRateConverterSettings() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public AVSampleRateConverterAlgorithm getAlgorithm() {
        if (this.data.containsKey(AVSampleRateConverterSettings.AlgorithmKey())) {
            NSString val = (NSString)this.data.get(AVSampleRateConverterSettings.AlgorithmKey());
            return AVSampleRateConverterAlgorithm.valueOf(val);
        }
        return null;
    }

    public AVSampleRateConverterSettings setAlgorithm(AVSampleRateConverterAlgorithm algorithm) {
        this.data.put(AVSampleRateConverterSettings.AlgorithmKey(), algorithm.value());
        return this;
    }

    public AVAudioQuality getAudioQuality() {
        if (this.data.containsKey(AVSampleRateConverterSettings.AudioQualityKey())) {
            NSNumber val = (NSNumber)this.data.get(AVSampleRateConverterSettings.AudioQualityKey());
            return AVAudioQuality.valueOf(val.longValue());
        }
        return null;
    }

    public AVSampleRateConverterSettings setAudioQuality(AVAudioQuality quality) {
        this.data.put(AVSampleRateConverterSettings.AudioQualityKey(), NSNumber.valueOf(quality.value()));
        return this;
    }

    @GlobalValue(symbol="AVSampleRateConverterAlgorithmKey", optional=true)
    protected static native NSString AlgorithmKey();

    @GlobalValue(symbol="AVSampleRateConverterAudioQualityKey", optional=true)
    protected static native NSString AudioQualityKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVSampleRateConverterSettings.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVSampleRateConverterSettings toObject(Class<AVSampleRateConverterSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVSampleRateConverterSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVSampleRateConverterSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

