/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVVideoCleanAperture;
import org.robovm.apple.avfoundation.AVVideoScalingMode;
import org.robovm.apple.avfoundation.AVVideoSettings;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corevideo.CVPixelBufferAttributes;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Library;

@Library(value="AVFoundation")
public class AVPixelBufferAttributes
extends CVPixelBufferAttributes {
    protected AVPixelBufferAttributes(CFDictionary data) {
        this.data = data;
    }

    public AVPixelBufferAttributes() {
        this.data = CFMutableDictionary.create();
    }

    public double getPixelAspectRatioHorizontalSpacing() {
        CFDictionary val;
        if (this.data.containsKey((NativeObject)AVVideoSettings.PixelAspectRatioKey()) && (val = this.data.get((NativeObject)AVVideoSettings.PixelAspectRatioKey(), CFDictionary.class)).containsKey((NativeObject)AVVideoSettings.PixelAspectRatioHorizontalSpacingKey())) {
            CFNumber n = val.get((NativeObject)AVVideoSettings.PixelAspectRatioHorizontalSpacingKey(), CFNumber.class);
            return n.doubleValue();
        }
        return 0.0;
    }

    public AVPixelBufferAttributes setPixelAspectRatioHorizontalSpacing(double spacing) {
        CFDictionary val = null;
        val = this.data.containsKey((NativeObject)AVVideoSettings.PixelAspectRatioKey()) ? this.data.get((NativeObject)AVVideoSettings.PixelAspectRatioKey(), CFDictionary.class) : CFMutableDictionary.create();
        ((CFDictionary)val).put((NativeObject)AVVideoSettings.PixelAspectRatioHorizontalSpacingKey(), CFNumber.valueOf(spacing));
        this.data.put((NativeObject)AVVideoSettings.PixelAspectRatioKey(), val);
        return this;
    }

    public double getPixelAspectRatioVerticalSpacing() {
        CFDictionary val;
        if (this.data.containsKey((NativeObject)AVVideoSettings.PixelAspectRatioKey()) && (val = this.data.get((NativeObject)AVVideoSettings.PixelAspectRatioKey(), CFDictionary.class)).containsKey((NativeObject)AVVideoSettings.PixelAspectRatioVerticalSpacingKey())) {
            CFNumber n = val.get((NativeObject)AVVideoSettings.PixelAspectRatioVerticalSpacingKey(), CFNumber.class);
            return n.doubleValue();
        }
        return 0.0;
    }

    public AVPixelBufferAttributes setPixelAspectRatioVerticalSpacing(double spacing) {
        CFDictionary val = null;
        val = this.data.containsKey((NativeObject)AVVideoSettings.PixelAspectRatioKey()) ? this.data.get((NativeObject)AVVideoSettings.PixelAspectRatioKey(), CFDictionary.class) : CFMutableDictionary.create();
        ((CFDictionary)val).put((NativeObject)AVVideoSettings.PixelAspectRatioVerticalSpacingKey(), CFNumber.valueOf(spacing));
        this.data.put((NativeObject)AVVideoSettings.PixelAspectRatioKey(), val);
        return this;
    }

    public AVVideoCleanAperture getCleanAperture() {
        if (this.data.containsKey((NativeObject)AVVideoSettings.CleanApertureKey())) {
            NSDictionary val = this.data.get((NativeObject)AVVideoSettings.CleanApertureKey(), NSDictionary.class);
            return new AVVideoCleanAperture(val);
        }
        return null;
    }

    public AVPixelBufferAttributes setCleanAperture(AVVideoCleanAperture cleanAperture) {
        this.data.put((NativeObject)AVVideoSettings.CleanApertureKey(), (NativeObject)cleanAperture.getDictionary());
        return this;
    }

    public AVVideoScalingMode getScalingMode() {
        if (this.data.containsKey((NativeObject)AVVideoSettings.ScalingModeKey())) {
            NSString val = this.data.get((NativeObject)AVVideoSettings.ScalingModeKey(), NSString.class);
            return AVVideoScalingMode.valueOf(val);
        }
        return null;
    }

    public AVPixelBufferAttributes setScalingMode(AVVideoScalingMode scalingMode) {
        this.data.put((NativeObject)AVVideoSettings.ScalingModeKey(), (NativeObject)scalingMode.value());
        return this;
    }

    static {
        Bro.bind(AVPixelBufferAttributes.class);
    }
}

