/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVMetadataKeySpace
extends CocoaUtility {
    public static final AVMetadataKeySpace Common;
    public static final AVMetadataKeySpace QuickTimeUserData;
    public static final AVMetadataKeySpace ISOUserData;
    public static final AVMetadataKeySpace QuickTimeMetadata;
    public static final AVMetadataKeySpace iTunes;
    public static final AVMetadataKeySpace ID3;
    public static final AVMetadataKeySpace Icy;
    private static AVMetadataKeySpace[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVMetadataKeySpace(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVMetadataKeySpace valueOf(NSString value) {
        for (AVMetadataKeySpace v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMetadataKeySpace.class.getName());
    }

    @GlobalValue(symbol="AVMetadataKeySpaceCommon", optional=true)
    protected static native NSString CommonValue();

    @GlobalValue(symbol="AVMetadataKeySpaceQuickTimeUserData", optional=true)
    protected static native NSString QuickTimeUserDataValue();

    @GlobalValue(symbol="AVMetadataKeySpaceISOUserData", optional=true)
    protected static native NSString ISOUserDataValue();

    @GlobalValue(symbol="AVMetadataKeySpaceQuickTimeMetadata", optional=true)
    protected static native NSString QuickTimeMetadataValue();

    @GlobalValue(symbol="AVMetadataKeySpaceiTunes", optional=true)
    protected static native NSString iTunesValue();

    @GlobalValue(symbol="AVMetadataKeySpaceID3", optional=true)
    protected static native NSString ID3Value();

    @GlobalValue(symbol="AVMetadataKeySpaceIcy", optional=true)
    protected static native NSString IcyValue();

    static {
        Bro.bind(AVMetadataKeySpace.class);
        Common = new AVMetadataKeySpace("CommonValue");
        QuickTimeUserData = new AVMetadataKeySpace("QuickTimeUserDataValue");
        ISOUserData = new AVMetadataKeySpace("ISOUserDataValue");
        QuickTimeMetadata = new AVMetadataKeySpace("QuickTimeMetadataValue");
        iTunes = new AVMetadataKeySpace("iTunesValue");
        ID3 = new AVMetadataKeySpace("ID3Value");
        Icy = new AVMetadataKeySpace("IcyValue");
        values = new AVMetadataKeySpace[]{Common, QuickTimeUserData, ISOUserData, QuickTimeMetadata, iTunes, ID3, Icy};
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMetadataKeySpace toObject(Class<AVMetadataKeySpace> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMetadataKeySpace.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMetadataKeySpace o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

