/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AVFoundation")
@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
public abstract class AVMetadataKey {
    private static final List<Class<? extends AVMetadataKey>> allSubClasses = new ArrayList<Class<? extends AVMetadataKey>>();
    private static final int ABSTRACT = 1024;

    public abstract NSString value();

    public static AVMetadataKey valueOf(NSString value) {
        Class[] args = new Class[]{NSString.class};
        for (Class<? extends AVMetadataKey> cls : allSubClasses) {
            try {
                Bro.bind(cls);
                Method m = cls.getMethod("valueOf", args);
                AVMetadataKey key = (AVMetadataKey)m.invoke(null, new Object[0]);
                if (key == null) continue;
                return key;
            }
            catch (Throwable e) {
                System.err.println("WARN: Failed to call valueOf() for the AVMetadataKey subclass " + cls.getName());
            }
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMetadataKey.class.getName());
    }

    static {
        Class[] classes = VM.listClasses(AVMetadataKey.class, (ClassLoader)ClassLoader.getSystemClassLoader());
        Class<AVMetadataKey> baseClass = AVMetadataKey.class;
        for (Class cls : classes) {
            if (cls == baseClass || (cls.getModifiers() & 0x400) != 0) continue;
            allSubClasses.add(cls);
        }
        Bro.bind(AVMetadataKey.class);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMetadataKey> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVMetadataKey> list = new ArrayList<AVMetadataKey>();
            for (NSString str : o) {
                list.add(AVMetadataKey.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVMetadataKey> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVMetadataKey i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMetadataKey toObject(Class<AVMetadataKey> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMetadataKey.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMetadataKey o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

