/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVMetadataFormat
extends CocoaUtility {
    public static final AVMetadataFormat QuickTimeUserData;
    public static final AVMetadataFormat QuickTimeMetadata;
    public static final AVMetadataFormat iTunesMetadata;
    public static final AVMetadataFormat ID3Metadata;
    public static final AVMetadataFormat ISOUserData;
    public static final AVMetadataFormat HLSMetadata;
    private static AVMetadataFormat[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVMetadataFormat(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVMetadataFormat valueOf(NSString value) {
        for (AVMetadataFormat v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMetadataFormat.class.getName());
    }

    @GlobalValue(symbol="AVMetadataFormatQuickTimeUserData", optional=true)
    protected static native NSString QuickTimeUserDataValue();

    @GlobalValue(symbol="AVMetadataFormatISOUserData", optional=true)
    protected static native NSString ISOUserDataValue();

    @GlobalValue(symbol="AVMetadataFormatQuickTimeMetadata", optional=true)
    protected static native NSString QuickTimeMetadataValue();

    @GlobalValue(symbol="AVMetadataFormatiTunesMetadata", optional=true)
    protected static native NSString iTunesMetadataValue();

    @GlobalValue(symbol="AVMetadataFormatID3Metadata", optional=true)
    protected static native NSString ID3MetadataValue();

    @GlobalValue(symbol="AVMetadataFormatHLSMetadata", optional=true)
    protected static native NSString HLSMetadataValue();

    static {
        Bro.bind(AVMetadataFormat.class);
        QuickTimeUserData = new AVMetadataFormat("QuickTimeUserDataValue");
        QuickTimeMetadata = new AVMetadataFormat("QuickTimeMetadataValue");
        iTunesMetadata = new AVMetadataFormat("iTunesMetadataValue");
        ID3Metadata = new AVMetadataFormat("ID3MetadataValue");
        ISOUserData = new AVMetadataFormat("ISOUserDataValue");
        HLSMetadata = new AVMetadataFormat("HLSMetadataValue");
        values = new AVMetadataFormat[]{QuickTimeUserData, QuickTimeMetadata, iTunesMetadata, ID3Metadata, ISOUserData, HLSMetadata};
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMetadataFormat> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVMetadataFormat> list = new ArrayList<AVMetadataFormat>();
            for (NSString str : o) {
                list.add(AVMetadataFormat.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVMetadataFormat> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVMetadataFormat i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMetadataFormat toObject(Class<AVMetadataFormat> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMetadataFormat.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMetadataFormat o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

