/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVMediaType
extends CocoaUtility {
    public static final AVMediaType Video;
    public static final AVMediaType Audio;
    public static final AVMediaType Text;
    public static final AVMediaType ClosedCaption;
    public static final AVMediaType Subtitle;
    public static final AVMediaType Timecode;
    public static final AVMediaType Muxed;
    public static final AVMediaType Metadata;
    private static AVMediaType[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVMediaType(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVMediaType valueOf(NSString value) {
        for (AVMediaType v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMediaType.class.getName());
    }

    @GlobalValue(symbol="AVMediaTypeVideo", optional=true)
    protected static native NSString VideoValue();

    @GlobalValue(symbol="AVMediaTypeAudio", optional=true)
    protected static native NSString AudioValue();

    @GlobalValue(symbol="AVMediaTypeText", optional=true)
    protected static native NSString TextValue();

    @GlobalValue(symbol="AVMediaTypeClosedCaption", optional=true)
    protected static native NSString ClosedCaptionValue();

    @GlobalValue(symbol="AVMediaTypeSubtitle", optional=true)
    protected static native NSString SubtitleValue();

    @GlobalValue(symbol="AVMediaTypeTimecode", optional=true)
    protected static native NSString TimecodeValue();

    @GlobalValue(symbol="AVMediaTypeMetadata", optional=true)
    protected static native NSString MetadataValue();

    @GlobalValue(symbol="AVMediaTypeMuxed", optional=true)
    protected static native NSString MuxedValue();

    static {
        Bro.bind(AVMediaType.class);
        Video = new AVMediaType("VideoValue");
        Audio = new AVMediaType("AudioValue");
        Text = new AVMediaType("TextValue");
        ClosedCaption = new AVMediaType("ClosedCaptionValue");
        Subtitle = new AVMediaType("SubtitleValue");
        Timecode = new AVMediaType("TimecodeValue");
        Muxed = new AVMediaType("MuxedValue");
        Metadata = new AVMediaType("MetadataValue");
        values = new AVMediaType[]{Video, Audio, Text, ClosedCaption, Subtitle, Timecode, Muxed, Metadata};
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMediaType> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVMediaType> list = new ArrayList<AVMediaType>();
            for (NSString str : o) {
                list.add(AVMediaType.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVMediaType> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVMediaType i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMediaType toObject(Class<AVMediaType> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMediaType.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMediaType o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

