/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVMediaCharacteristic
extends CocoaUtility {
    public static final AVMediaCharacteristic Visual;
    public static final AVMediaCharacteristic Audible;
    public static final AVMediaCharacteristic Legible;
    public static final AVMediaCharacteristic FrameBased;
    public static final AVMediaCharacteristic IsMainProgramContent;
    public static final AVMediaCharacteristic IsAuxiliaryContent;
    public static final AVMediaCharacteristic ContainsOnlyForcedSubtitles;
    public static final AVMediaCharacteristic TranscribesSpokenDialogForAccessibility;
    public static final AVMediaCharacteristic DescribesMusicAndSoundForAccessibility;
    public static final AVMediaCharacteristic DescribesVideoForAccessibility;
    public static final AVMediaCharacteristic EasyToRead;
    private static AVMediaCharacteristic[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVMediaCharacteristic(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVMediaCharacteristic valueOf(NSString value) {
        for (AVMediaCharacteristic v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVMediaCharacteristic.class.getName());
    }

    @GlobalValue(symbol="AVMediaCharacteristicVisual", optional=true)
    protected static native NSString VisualValue();

    @GlobalValue(symbol="AVMediaCharacteristicAudible", optional=true)
    protected static native NSString AudibleValue();

    @GlobalValue(symbol="AVMediaCharacteristicLegible", optional=true)
    protected static native NSString LegibleValue();

    @GlobalValue(symbol="AVMediaCharacteristicFrameBased", optional=true)
    protected static native NSString FrameBasedValue();

    @GlobalValue(symbol="AVMediaCharacteristicIsMainProgramContent", optional=true)
    protected static native NSString IsMainProgramContentValue();

    @GlobalValue(symbol="AVMediaCharacteristicIsAuxiliaryContent", optional=true)
    protected static native NSString IsAuxiliaryContentValue();

    @GlobalValue(symbol="AVMediaCharacteristicContainsOnlyForcedSubtitles", optional=true)
    protected static native NSString ContainsOnlyForcedSubtitlesValue();

    @GlobalValue(symbol="AVMediaCharacteristicTranscribesSpokenDialogForAccessibility", optional=true)
    protected static native NSString TranscribesSpokenDialogForAccessibilityValue();

    @GlobalValue(symbol="AVMediaCharacteristicDescribesMusicAndSoundForAccessibility", optional=true)
    protected static native NSString DescribesMusicAndSoundForAccessibilityValue();

    @GlobalValue(symbol="AVMediaCharacteristicEasyToRead", optional=true)
    protected static native NSString EasyToReadValue();

    @GlobalValue(symbol="AVMediaCharacteristicDescribesVideoForAccessibility", optional=true)
    protected static native NSString DescribesVideoForAccessibilityValue();

    static {
        Bro.bind(AVMediaCharacteristic.class);
        Visual = new AVMediaCharacteristic("VisualValue");
        Audible = new AVMediaCharacteristic("AudibleValue");
        Legible = new AVMediaCharacteristic("LegibleValue");
        FrameBased = new AVMediaCharacteristic("FrameBasedValue");
        IsMainProgramContent = new AVMediaCharacteristic("IsMainProgramContentValue");
        IsAuxiliaryContent = new AVMediaCharacteristic("IsAuxiliaryContentValue");
        ContainsOnlyForcedSubtitles = new AVMediaCharacteristic("ContainsOnlyForcedSubtitlesValue");
        TranscribesSpokenDialogForAccessibility = new AVMediaCharacteristic("TranscribesSpokenDialogForAccessibilityValue");
        DescribesMusicAndSoundForAccessibility = new AVMediaCharacteristic("DescribesMusicAndSoundForAccessibilityValue");
        DescribesVideoForAccessibility = new AVMediaCharacteristic("DescribesVideoForAccessibilityValue");
        EasyToRead = new AVMediaCharacteristic("EasyToReadValue");
        values = new AVMediaCharacteristic[]{Visual, Audible, Legible, FrameBased, IsMainProgramContent, IsAuxiliaryContent, ContainsOnlyForcedSubtitles, TranscribesSpokenDialogForAccessibility, DescribesMusicAndSoundForAccessibility, DescribesVideoForAccessibility, EasyToRead};
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVMediaCharacteristic> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVMediaCharacteristic> list = new ArrayList<AVMediaCharacteristic>();
            for (NSString str : o) {
                list.add(AVMediaCharacteristic.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVMediaCharacteristic> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVMediaCharacteristic i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVMediaCharacteristic toObject(Class<AVMediaCharacteristic> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVMediaCharacteristic.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVMediaCharacteristic o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

