/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioEncoderSettings;
import org.robovm.apple.avfoundation.AVSampleRateConverterSettings;
import org.robovm.apple.coreaudio.AudioChannelLayout;
import org.robovm.apple.coreaudio.AudioFormat;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVAudioSettings
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;
    private AVAudioEncoderSettings encoderSettings;
    private AVSampleRateConverterSettings sampleRateConverterSettings;

    protected AVAudioSettings(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVAudioSettings() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public AVAudioEncoderSettings getEncoderSettings() {
        if (this.encoderSettings == null) {
            this.encoderSettings = new AVAudioEncoderSettings(this.data);
        }
        return this.encoderSettings;
    }

    public AVAudioSettings setEncoderSettings(AVAudioEncoderSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.encoderSettings = settings;
        this.data.putAll(settings.getDictionary());
        return this;
    }

    public AVSampleRateConverterSettings getSampleRateConverterSettings() {
        if (this.sampleRateConverterSettings == null) {
            this.sampleRateConverterSettings = new AVSampleRateConverterSettings(this.data);
        }
        return this.sampleRateConverterSettings;
    }

    public AVAudioSettings setSampleRateConverterSettings(AVSampleRateConverterSettings settings) {
        if (settings == null) {
            throw new NullPointerException("settings");
        }
        this.sampleRateConverterSettings = settings;
        this.data.putAll(settings.getDictionary());
        return this;
    }

    public AudioFormat getFormat() {
        if (this.data.containsKey(AVAudioSettings.FormatIDKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.FormatIDKey());
            return AudioFormat.valueOf(val.longValue());
        }
        return null;
    }

    public AVAudioSettings setFormat(AudioFormat format) {
        this.data.put(AVAudioSettings.FormatIDKey(), NSNumber.valueOf(format.value()));
        return this;
    }

    public double getSampleRate() {
        if (this.data.containsKey(AVAudioSettings.SampleRateKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.SampleRateKey());
            return val.doubleValue();
        }
        return 0.0;
    }

    public AVAudioSettings setSampleRate(double sampleRate) {
        this.data.put(AVAudioSettings.SampleRateKey(), NSNumber.valueOf(sampleRate));
        return this;
    }

    public int getNumberOfChannels() {
        if (this.data.containsKey(AVAudioSettings.NumberOfChannelsKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.NumberOfChannelsKey());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioSettings setNumberOfChannels(int channels) {
        this.data.put(AVAudioSettings.NumberOfChannelsKey(), NSNumber.valueOf(channels));
        return this;
    }

    public int getLinearPCMBitDepth() {
        if (this.data.containsKey(AVAudioSettings.BitDepthKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.BitDepthKey());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioSettings setLinearPCMBitDepth(int bitDepth) {
        this.data.put(AVAudioSettings.BitDepthKey(), NSNumber.valueOf(bitDepth));
        return this;
    }

    public boolean isLinearPCMBigEndian() {
        if (this.data.containsKey(AVAudioSettings.IsBigEndianKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.IsBigEndianKey());
            return val.booleanValue();
        }
        return false;
    }

    public AVAudioSettings setLinearPCMBigEndian(boolean bigEndian) {
        this.data.put(AVAudioSettings.IsBigEndianKey(), NSNumber.valueOf(bigEndian));
        return this;
    }

    public boolean isLinearPCMFloat() {
        if (this.data.containsKey(AVAudioSettings.IsFloatKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.IsFloatKey());
            return val.booleanValue();
        }
        return false;
    }

    public AVAudioSettings setLinearPCMFloat(boolean isFloat) {
        this.data.put(AVAudioSettings.IsFloatKey(), NSNumber.valueOf(isFloat));
        return this;
    }

    public boolean isLinearPCMNonInterleaved() {
        if (this.data.containsKey(AVAudioSettings.IsNonInterleaved())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioSettings.IsNonInterleaved());
            return val.booleanValue();
        }
        return false;
    }

    public AVAudioSettings setLinearPCMNonInterleaved(boolean nonInterleaved) {
        this.data.put(AVAudioSettings.IsNonInterleaved(), NSNumber.valueOf(nonInterleaved));
        return this;
    }

    public AudioChannelLayout getChannelLayout() {
        if (this.data.containsKey(AVAudioSettings.ChannelLayoutKey())) {
            NSData val = (NSData)this.data.get(AVAudioSettings.ChannelLayoutKey());
            val.getStructData(AudioChannelLayout.class);
        }
        return null;
    }

    public AVAudioSettings setChannelLayout(AudioChannelLayout channelLayout) {
        this.data.put(AVAudioSettings.ChannelLayoutKey(), new NSData(channelLayout));
        return this;
    }

    @GlobalValue(symbol="AVFormatIDKey", optional=true)
    protected static native NSString FormatIDKey();

    @GlobalValue(symbol="AVSampleRateKey", optional=true)
    protected static native NSString SampleRateKey();

    @GlobalValue(symbol="AVNumberOfChannelsKey", optional=true)
    protected static native NSString NumberOfChannelsKey();

    @GlobalValue(symbol="AVLinearPCMBitDepthKey", optional=true)
    protected static native NSString BitDepthKey();

    @GlobalValue(symbol="AVLinearPCMIsBigEndianKey", optional=true)
    protected static native NSString IsBigEndianKey();

    @GlobalValue(symbol="AVLinearPCMIsFloatKey", optional=true)
    protected static native NSString IsFloatKey();

    @GlobalValue(symbol="AVLinearPCMIsNonInterleaved", optional=true)
    protected static native NSString IsNonInterleaved();

    @GlobalValue(symbol="AVChannelLayoutKey", optional=true)
    protected static native NSString ChannelLayoutKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVAudioSettings.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAudioSettings toObject(Class<AVAudioSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVAudioSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVAudioSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

