/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVAudioSessionCategory
extends CocoaUtility {
    public static final AVAudioSessionCategory Ambient;
    public static final AVAudioSessionCategory SoloAmbient;
    public static final AVAudioSessionCategory Playback;
    public static final AVAudioSessionCategory Record;
    public static final AVAudioSessionCategory PlayAndRecord;
    public static final AVAudioSessionCategory AudioProcessing;
    public static final AVAudioSessionCategory MultiRoute;
    private static AVAudioSessionCategory[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVAudioSessionCategory(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVAudioSessionCategory valueOf(NSString value) {
        for (AVAudioSessionCategory v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVAudioSessionCategory.class.getName());
    }

    @GlobalValue(symbol="AVAudioSessionCategoryAmbient", optional=true)
    protected static native NSString AmbientValue();

    @GlobalValue(symbol="AVAudioSessionCategorySoloAmbient", optional=true)
    protected static native NSString SoloAmbientValue();

    @GlobalValue(symbol="AVAudioSessionCategoryPlayback", optional=true)
    protected static native NSString PlaybackValue();

    @GlobalValue(symbol="AVAudioSessionCategoryRecord", optional=true)
    protected static native NSString RecordValue();

    @GlobalValue(symbol="AVAudioSessionCategoryPlayAndRecord", optional=true)
    protected static native NSString PlayAndRecordValue();

    @GlobalValue(symbol="AVAudioSessionCategoryAudioProcessing", optional=true)
    protected static native NSString AudioProcessingValue();

    @GlobalValue(symbol="AVAudioSessionCategoryMultiRoute", optional=true)
    protected static native NSString MultiRouteValue();

    static {
        Bro.bind(AVAudioSessionCategory.class);
        Ambient = new AVAudioSessionCategory("AmbientValue");
        SoloAmbient = new AVAudioSessionCategory("SoloAmbientValue");
        Playback = new AVAudioSessionCategory("PlaybackValue");
        Record = new AVAudioSessionCategory("RecordValue");
        PlayAndRecord = new AVAudioSessionCategory("PlayAndRecordValue");
        AudioProcessing = new AVAudioSessionCategory("AudioProcessingValue");
        MultiRoute = new AVAudioSessionCategory("MultiRouteValue");
        values = new AVAudioSessionCategory[]{Ambient, SoloAmbient, Playback, Record, PlayAndRecord, AudioProcessing, MultiRoute};
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAudioSessionCategory toObject(Class<AVAudioSessionCategory> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVAudioSessionCategory.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVAudioSessionCategory o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

