/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioCommonFormat;
import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.avfoundation.AVAudioPCMBuffer;
import org.robovm.apple.avfoundation.AVAudioSettings;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioFile
extends NSObject {
    public AVAudioFile() {
    }

    protected AVAudioFile(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public AVAudioFile(NSURL fileURL) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(fileURL, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    public AVAudioFile(NSURL fileURL, AVAudioCommonFormat format, boolean interleaved) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(fileURL, format, interleaved, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    public AVAudioFile(NSURL fileURL, AVAudioSettings settings) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(fileURL, settings, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    public AVAudioFile(NSURL fileURL, AVAudioSettings settings, AVAudioCommonFormat format, boolean interleaved) throws NSErrorException {
        super(null);
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        long handle = this.init(fileURL, settings, format, interleaved, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        this.initObject(handle);
    }

    @Property(selector="url")
    public native NSURL getUrl();

    @Property(selector="fileFormat")
    public native AVAudioFormat getFileFormat();

    @Property(selector="processingFormat")
    public native AVAudioFormat getProcessingFormat();

    @Property(selector="length")
    public native long getLength();

    @Property(selector="framePosition")
    public native long getFramePosition();

    @Property(selector="setFramePosition:")
    public native void setFramePosition(long var1);

    @Method(selector="initForReading:error:")
    @Pointer
    private native long init(NSURL var1, NSError.NSErrorPtr var2);

    @Method(selector="initForReading:commonFormat:interleaved:error:")
    @Pointer
    private native long init(NSURL var1, AVAudioCommonFormat var2, boolean var3, NSError.NSErrorPtr var4);

    @Method(selector="initForWriting:settings:error:")
    @Pointer
    private native long init(NSURL var1, AVAudioSettings var2, NSError.NSErrorPtr var3);

    @Method(selector="initForWriting:settings:commonFormat:interleaved:error:")
    @Pointer
    private native long init(NSURL var1, AVAudioSettings var2, AVAudioCommonFormat var3, boolean var4, NSError.NSErrorPtr var5);

    public boolean readIntoBuffer(AVAudioPCMBuffer buffer) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.readIntoBuffer(buffer, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readIntoBuffer:error:")
    private native boolean readIntoBuffer(AVAudioPCMBuffer var1, NSError.NSErrorPtr var2);

    public boolean readIntoBuffer(AVAudioPCMBuffer buffer, int frames) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.readIntoBuffer(buffer, frames, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="readIntoBuffer:frameCount:error:")
    private native boolean readIntoBuffer(AVAudioPCMBuffer var1, int var2, NSError.NSErrorPtr var3);

    public boolean writeFromBuffer(AVAudioPCMBuffer buffer) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.writeFromBuffer(buffer, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="writeFromBuffer:error:")
    private native boolean writeFromBuffer(AVAudioPCMBuffer var1, NSError.NSErrorPtr var2);

    static {
        ObjCRuntime.bind(AVAudioFile.class);
    }

    public static class AVAudioFilePtr
    extends Ptr<AVAudioFile, AVAudioFilePtr> {
    }
}

