/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.audiotoolbox.MusicSequence;
import org.robovm.apple.avfoundation.AVAudioFormat;
import org.robovm.apple.avfoundation.AVAudioInputNode;
import org.robovm.apple.avfoundation.AVAudioMixerNode;
import org.robovm.apple.avfoundation.AVAudioNode;
import org.robovm.apple.avfoundation.AVAudioOutputNode;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSNotification;
import org.robovm.apple.foundation.NSNotificationCenter;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSOperationQueue;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock1;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedUInt;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAudioEngine
extends NSObject {
    public AVAudioEngine() {
    }

    protected AVAudioEngine(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="musicSequence")
    public native MusicSequence getMusicSequence();

    @Property(selector="setMusicSequence:")
    public native void setMusicSequence(MusicSequence var1);

    @Property(selector="outputNode")
    public native AVAudioOutputNode getOutputNode();

    @Property(selector="inputNode")
    public native AVAudioInputNode getInputNode();

    @Property(selector="mainMixerNode")
    public native AVAudioMixerNode getMainMixerNode();

    @Property(selector="isRunning")
    public native boolean isRunning();

    @GlobalValue(symbol="AVAudioEngineConfigurationChangeNotification", optional=true)
    public static native NSString ConfigurationChangeNotification();

    @Method(selector="attachNode:")
    public native void attachNode(AVAudioNode var1);

    @Method(selector="detachNode:")
    public native void detachNode(AVAudioNode var1);

    @Method(selector="connect:to:fromBus:toBus:format:")
    public native void connect(AVAudioNode var1, AVAudioNode var2, @MachineSizedUInt long var3, @MachineSizedUInt long var5, AVAudioFormat var7);

    @Method(selector="connect:to:format:")
    public native void connect(AVAudioNode var1, AVAudioNode var2, AVAudioFormat var3);

    @Method(selector="disconnectNodeInput:bus:")
    public native void disconnectNodeInput(AVAudioNode var1, @MachineSizedUInt long var2);

    @Method(selector="disconnectNodeInput:")
    public native void disconnectNodeInput(AVAudioNode var1);

    @Method(selector="disconnectNodeOutput:bus:")
    public native void disconnectNodeOutput(AVAudioNode var1, @MachineSizedUInt long var2);

    @Method(selector="disconnectNodeOutput:")
    public native void disconnectNodeOutput(AVAudioNode var1);

    @Method(selector="prepare")
    public native void prepare();

    public boolean start() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.start(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="startAndReturnError:")
    private native boolean start(NSError.NSErrorPtr var1);

    @Method(selector="pause")
    public native void pause();

    @Method(selector="reset")
    public native void reset();

    @Method(selector="stop")
    public native void stop();

    static {
        ObjCRuntime.bind(AVAudioEngine.class);
    }

    public static class AVAudioEnginePtr
    extends Ptr<AVAudioEngine, AVAudioEnginePtr> {
    }

    public static class Notifications {
        public static NSObject observeConfigurationChange(AVAudioEngine object, final VoidBlock1<AVAudioEngine> block) {
            return NSNotificationCenter.getDefaultCenter().addObserver(AVAudioEngine.ConfigurationChangeNotification(), object, NSOperationQueue.getMainQueue(), new VoidBlock1<NSNotification>(){

                public void invoke(NSNotification a) {
                    block.invoke((Object)((AVAudioEngine)a.getObject()));
                }
            });
        }
    }
}

