/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAudioBitRateStrategy;
import org.robovm.apple.avfoundation.AVAudioQuality;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSMutableDictionary;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVAudioEncoderSettings
extends CocoaUtility {
    private NSDictionary<NSString, NSObject> data;

    protected AVAudioEncoderSettings(NSDictionary<NSString, NSObject> data) {
        this.data = data;
    }

    public AVAudioEncoderSettings() {
        this.data = new NSMutableDictionary<NSString, NSObject>();
    }

    public NSDictionary<NSString, NSObject> getDictionary() {
        return this.data;
    }

    public AVAudioQuality getAudioQuality() {
        if (this.data.containsKey(AVAudioEncoderSettings.AudioQualityKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioEncoderSettings.AudioQualityKey());
            return AVAudioQuality.valueOf(val.longValue());
        }
        return null;
    }

    public AVAudioEncoderSettings setAudioQuality(AVAudioQuality quality) {
        this.data.put(AVAudioEncoderSettings.AudioQualityKey(), NSNumber.valueOf(quality.value()));
        return this;
    }

    public AVAudioQuality getAudioQualityForVBR() {
        if (this.data.containsKey(AVAudioEncoderSettings.AudioQualityForVBRKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioEncoderSettings.AudioQualityForVBRKey());
            return AVAudioQuality.valueOf(val.longValue());
        }
        return null;
    }

    public AVAudioEncoderSettings setAudioQualityForVBR(AVAudioQuality quality) {
        this.data.put(AVAudioEncoderSettings.AudioQualityForVBRKey(), NSNumber.valueOf(quality.value()));
        return this;
    }

    public int getBitRate() {
        if (this.data.containsKey(AVAudioEncoderSettings.BitRateKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioEncoderSettings.BitRateKey());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitRate(int bitRate) {
        this.data.put(AVAudioEncoderSettings.BitRateKey(), NSNumber.valueOf(bitRate));
        return this;
    }

    public int getBitRatePerChannel() {
        if (this.data.containsKey(AVAudioEncoderSettings.BitRatePerChannelKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioEncoderSettings.BitRatePerChannelKey());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitRatePerChannel(int bitRate) {
        this.data.put(AVAudioEncoderSettings.BitRatePerChannelKey(), NSNumber.valueOf(bitRate));
        return this;
    }

    public AVAudioBitRateStrategy getBitRateStrategy() {
        if (this.data.containsKey(AVAudioEncoderSettings.BitRateStrategyKey())) {
            NSString val = (NSString)this.data.get(AVAudioEncoderSettings.BitRateStrategyKey());
            return AVAudioBitRateStrategy.valueOf(val);
        }
        return null;
    }

    public AVAudioEncoderSettings setBitRateStrategy(AVAudioBitRateStrategy bitRateStrategy) {
        this.data.put(AVAudioEncoderSettings.BitRateStrategyKey(), bitRateStrategy.value());
        return this;
    }

    public int getBitDepthHint() {
        if (this.data.containsKey(AVAudioEncoderSettings.BitDepthHintKey())) {
            NSNumber val = (NSNumber)this.data.get(AVAudioEncoderSettings.BitDepthHintKey());
            return val.intValue();
        }
        return 0;
    }

    public AVAudioEncoderSettings setBitDepthHint(int bitDepth) {
        this.data.put(AVAudioEncoderSettings.BitDepthHintKey(), NSNumber.valueOf(bitDepth));
        return this;
    }

    @GlobalValue(symbol="AVEncoderAudioQualityKey", optional=true)
    protected static native NSString AudioQualityKey();

    @GlobalValue(symbol="AVEncoderAudioQualityForVBRKey", optional=true)
    protected static native NSString AudioQualityForVBRKey();

    @GlobalValue(symbol="AVEncoderBitRateKey", optional=true)
    protected static native NSString BitRateKey();

    @GlobalValue(symbol="AVEncoderBitRatePerChannelKey", optional=true)
    protected static native NSString BitRatePerChannelKey();

    @GlobalValue(symbol="AVEncoderBitRateStrategyKey", optional=true)
    protected static native NSString BitRateStrategyKey();

    @GlobalValue(symbol="AVEncoderBitDepthHintKey", optional=true)
    protected static native NSString BitDepthHintKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(AVAudioEncoderSettings.class);
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAudioEncoderSettings toObject(Class<AVAudioEncoderSettings> cls, long handle, long flags) {
            NSDictionary o = (NSDictionary)NSObject.Marshaler.toObject(NSDictionary.class, handle, flags);
            if (o == null) {
                return null;
            }
            return new AVAudioEncoderSettings(o);
        }

        @MarshalsPointer
        public static long toNative(AVAudioEncoderSettings o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.data, flags);
        }
    }
}

