/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import org.robovm.apple.avfoundation.AVAssetWriterInputPassDescription;
import org.robovm.apple.avfoundation.AVAudioSettings;
import org.robovm.apple.avfoundation.AVMediaType;
import org.robovm.apple.avfoundation.AVMetadataItem;
import org.robovm.apple.avfoundation.AVTrackAssociationType;
import org.robovm.apple.avfoundation.AVVideoSettings;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMFormatDescription;
import org.robovm.apple.coremedia.CMSampleBuffer;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.dispatch.DispatchQueue;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAssetWriterInput
extends NSObject {
    public AVAssetWriterInput() {
    }

    protected AVAssetWriterInput(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public AVAssetWriterInput(AVMediaType mediaType, AVAudioSettings outputSettings) {
        super(null);
        this.initObject(this.init(mediaType, outputSettings.getDictionary()));
    }

    public AVAssetWriterInput(AVMediaType mediaType, AVAudioSettings outputSettings, CMFormatDescription sourceFormatHint) {
        super(null);
        this.initObject(this.init(mediaType, outputSettings.getDictionary(), sourceFormatHint));
    }

    public AVAssetWriterInput(AVMediaType mediaType, AVVideoSettings outputSettings) {
        super(null);
        this.initObject(this.init(mediaType, outputSettings.getDictionary()));
    }

    public AVAssetWriterInput(AVMediaType mediaType, AVVideoSettings outputSettings, CMFormatDescription sourceFormatHint) {
        super(null);
        this.initObject(this.init(mediaType, outputSettings.getDictionary(), sourceFormatHint));
    }

    public AVAudioSettings getOutputAudioSettings() {
        return new AVAudioSettings(this.getOutputSettings());
    }

    public AVVideoSettings getOutputVideoSettings() {
        return new AVVideoSettings(this.getOutputSettings());
    }

    @Property(selector="mediaType")
    public native AVMediaType getMediaType();

    @Property(selector="outputSettings")
    protected native NSDictionary<NSString, NSObject> getOutputSettings();

    @Property(selector="sourceFormatHint")
    public native CMFormatDescription getSourceFormatHint();

    @Property(selector="metadata")
    public native NSArray<AVMetadataItem> getMetadata();

    @Property(selector="setMetadata:")
    public native void setMetadata(NSArray<AVMetadataItem> var1);

    @Property(selector="isReadyForMoreMediaData")
    public native boolean isReadyForMoreMediaData();

    @Property(selector="expectsMediaDataInRealTime")
    public native boolean expectsMediaDataInRealTime();

    @Property(selector="setExpectsMediaDataInRealTime:")
    public native void setExpectsMediaDataInRealTime(boolean var1);

    @Property(selector="languageCode")
    public native String getLanguageCode();

    @Property(selector="setLanguageCode:")
    public native void setLanguageCode(String var1);

    @Property(selector="extendedLanguageTag")
    public native String getExtendedLanguageTag();

    @Property(selector="setExtendedLanguageTag:")
    public native void setExtendedLanguageTag(String var1);

    @Property(selector="naturalSize")
    @ByVal
    public native CGSize getNaturalSize();

    @Property(selector="setNaturalSize:")
    public native void setNaturalSize(@ByVal CGSize var1);

    @Property(selector="transform")
    @ByVal
    public native CGAffineTransform getTransform();

    @Property(selector="setTransform:")
    public native void setTransform(@ByVal CGAffineTransform var1);

    @Property(selector="preferredVolume")
    public native float getPreferredVolume();

    @Property(selector="setPreferredVolume:")
    public native void setPreferredVolume(float var1);

    @Property(selector="marksOutputTrackAsEnabled")
    public native boolean marksOutputTrackAsEnabled();

    @Property(selector="setMarksOutputTrackAsEnabled:")
    public native void setMarksOutputTrackAsEnabled(boolean var1);

    @Property(selector="mediaTimeScale")
    public native int getMediaTimeScale();

    @Property(selector="setMediaTimeScale:")
    public native void setMediaTimeScale(int var1);

    @Property(selector="preferredMediaChunkDuration")
    @ByVal
    public native CMTime getPreferredMediaChunkDuration();

    @Property(selector="setPreferredMediaChunkDuration:")
    public native void setPreferredMediaChunkDuration(@ByVal CMTime var1);

    @Property(selector="preferredMediaChunkAlignment")
    @MachineSizedSInt
    public native long getPreferredMediaChunkAlignment();

    @Property(selector="setPreferredMediaChunkAlignment:")
    public native void setPreferredMediaChunkAlignment(@MachineSizedSInt long var1);

    @Property(selector="sampleReferenceBaseURL")
    public native NSURL getSampleReferenceBaseURL();

    @Property(selector="setSampleReferenceBaseURL:")
    public native void setSampleReferenceBaseURL(NSURL var1);

    @Property(selector="performsMultiPassEncodingIfSupported")
    public native boolean performsMultiPassEncodingIfSupported();

    @Property(selector="setPerformsMultiPassEncodingIfSupported:")
    public native void setPerformsMultiPassEncodingIfSupported(boolean var1);

    @Property(selector="canPerformMultiplePasses")
    public native boolean canPerformMultiplePasses();

    @Property(selector="currentPassDescription")
    public native AVAssetWriterInputPassDescription getCurrentPassDescription();

    public static AVAssetWriterInput create(AVMediaType mediaType, AVAudioSettings outputSettings) {
        return AVAssetWriterInput.create(mediaType, outputSettings.getDictionary());
    }

    public static AVAssetWriterInput create(AVMediaType mediaType, AVAudioSettings outputSettings, CMFormatDescription sourceFormatHint) {
        return AVAssetWriterInput.create(mediaType, outputSettings.getDictionary(), sourceFormatHint);
    }

    public static AVAssetWriterInput create(AVMediaType mediaType, AVVideoSettings outputSettings) {
        return AVAssetWriterInput.create(mediaType, outputSettings.getDictionary());
    }

    public static AVAssetWriterInput create(AVMediaType mediaType, AVVideoSettings outputSettings, CMFormatDescription sourceFormatHint) {
        return AVAssetWriterInput.create(mediaType, outputSettings.getDictionary(), sourceFormatHint);
    }

    @Method(selector="initWithMediaType:outputSettings:")
    @Pointer
    protected native long init(AVMediaType var1, NSDictionary<NSString, NSObject> var2);

    @Method(selector="initWithMediaType:outputSettings:sourceFormatHint:")
    @Pointer
    protected native long init(AVMediaType var1, NSDictionary<NSString, NSObject> var2, CMFormatDescription var3);

    @Method(selector="requestMediaDataWhenReadyOnQueue:usingBlock:")
    public native void requestMediaDataWhenReady(DispatchQueue var1, @Block Runnable var2);

    @Method(selector="appendSampleBuffer:")
    public native boolean appendSampleBuffer(CMSampleBuffer var1);

    @Method(selector="markAsFinished")
    public native void markAsFinished();

    @Method(selector="assetWriterInputWithMediaType:outputSettings:")
    protected static native AVAssetWriterInput create(AVMediaType var0, NSDictionary<NSString, NSObject> var1);

    @Method(selector="assetWriterInputWithMediaType:outputSettings:sourceFormatHint:")
    protected static native AVAssetWriterInput create(AVMediaType var0, NSDictionary<NSString, NSObject> var1, CMFormatDescription var2);

    @Method(selector="canAddTrackAssociationWithTrackOfInput:type:")
    public native boolean canAddTrackAssociation(AVAssetWriterInput var1, AVTrackAssociationType var2);

    @Method(selector="addTrackAssociationWithTrackOfInput:type:")
    public native void addTrackAssociation(AVAssetWriterInput var1, AVTrackAssociationType var2);

    @Method(selector="respondToEachPassDescriptionOnQueue:usingBlock:")
    public native void respondToEachPassDescriptionOnQueue(DispatchQueue var1, @Block Runnable var2);

    @Method(selector="markCurrentPassAsFinished")
    public native void markCurrentPassAsFinished();

    static {
        ObjCRuntime.bind(AVAssetWriterInput.class);
    }

    public static class AVAssetWriterInputPtr
    extends Ptr<AVAssetWriterInput, AVAssetWriterInputPtr> {
    }
}

