/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAsset;
import org.robovm.apple.avfoundation.AVAssetImageGeneratorApertureMode;
import org.robovm.apple.avfoundation.AVAssetImageGeneratorResult;
import org.robovm.apple.avfoundation.AVVideoCompositing;
import org.robovm.apple.avfoundation.AVVideoComposition;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGSize;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.objc.block.VoidBlock5;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAssetImageGenerator
extends NSObject {
    public AVAssetImageGenerator() {
    }

    protected AVAssetImageGenerator(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    public AVAssetImageGenerator(AVAsset asset) {
        super(null);
        this.initObject(this.init(asset));
    }

    @Property(selector="asset")
    public native AVAsset getAsset();

    @Property(selector="appliesPreferredTrackTransform")
    public native boolean appliesPreferredTrackTransform();

    @Property(selector="setAppliesPreferredTrackTransform:")
    public native void setAppliesPreferredTrackTransform(boolean var1);

    @Property(selector="maximumSize")
    @ByVal
    public native CGSize getMaximumSize();

    @Property(selector="setMaximumSize:")
    public native void setMaximumSize(@ByVal CGSize var1);

    @Property(selector="apertureMode")
    public native AVAssetImageGeneratorApertureMode getApertureMode();

    @Property(selector="setApertureMode:")
    public native void setApertureMode(AVAssetImageGeneratorApertureMode var1);

    @Property(selector="videoComposition")
    public native AVVideoComposition getVideoComposition();

    @Property(selector="setVideoComposition:")
    public native void setVideoComposition(AVVideoComposition var1);

    @Property(selector="customVideoCompositor")
    public native AVVideoCompositing getCustomVideoCompositor();

    @Property(selector="requestedTimeToleranceBefore")
    @ByVal
    public native CMTime getRequestedTimeToleranceBefore();

    @Property(selector="setRequestedTimeToleranceBefore:")
    public native void setRequestedTimeToleranceBefore(@ByVal CMTime var1);

    @Property(selector="requestedTimeToleranceAfter")
    @ByVal
    public native CMTime getRequestedTimeToleranceAfter();

    @Property(selector="setRequestedTimeToleranceAfter:")
    public native void setRequestedTimeToleranceAfter(@ByVal CMTime var1);

    @Method(selector="initWithAsset:")
    @Pointer
    protected native long init(AVAsset var1);

    public CGImage getCGImageAtTime(@ByVal CMTime requestedTime, CMTime actualTime) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        CGImage result = this.getCGImageAtTime(requestedTime, actualTime, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Method(selector="copyCGImageAtTime:actualTime:error:")
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private native CGImage getCGImageAtTime(@ByVal CMTime var1, CMTime var2, NSError.NSErrorPtr var3);

    @Method(selector="generateCGImagesAsynchronouslyForTimes:completionHandler:")
    public native void generateCGImagesAsynchronously(@Marshaler(value=CMTime.AsValuedListMarshaler.class) List<CMTime> var1, @Block VoidBlock5<CMTime, CGImage, CMTime, AVAssetImageGeneratorResult, NSError> var2);

    @Method(selector="cancelAllCGImageGeneration")
    public native void cancelAllCGImageGeneration();

    @Method(selector="assetImageGeneratorWithAsset:")
    public static native AVAssetImageGenerator create(AVAsset var0);

    static {
        ObjCRuntime.bind(AVAssetImageGenerator.class);
    }

    public static class AVAssetImageGeneratorPtr
    extends Ptr<AVAssetImageGenerator, AVAssetImageGeneratorPtr> {
    }
}

