/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSMutableArray;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.LazyGlobalValue;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@org.robovm.rt.bro.annotation.Marshaler(value=Marshaler.class)
@Library(value="AVFoundation")
public class AVAssetExportPreset
extends CocoaUtility {
    public static final AVAssetExportPreset LowQuality;
    public static final AVAssetExportPreset MediumQuality;
    public static final AVAssetExportPreset HighestQuality;
    public static final AVAssetExportPreset Size640x480;
    public static final AVAssetExportPreset Size960x540;
    public static final AVAssetExportPreset Size1280x720;
    public static final AVAssetExportPreset Size1920x1080;
    public static final AVAssetExportPreset AppleM4A;
    public static final AVAssetExportPreset Passthrough;
    private static AVAssetExportPreset[] values;
    private final LazyGlobalValue<NSString> lazyGlobalValue;

    private AVAssetExportPreset(String getterName) {
        this.lazyGlobalValue = new LazyGlobalValue(this.getClass(), getterName);
    }

    public NSString value() {
        return (NSString)this.lazyGlobalValue.value();
    }

    public static AVAssetExportPreset valueOf(NSString value) {
        for (AVAssetExportPreset v : values) {
            if (!v.value().equals(value)) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + value + " found in " + AVAssetExportPreset.class.getName());
    }

    @GlobalValue(symbol="AVAssetExportPresetLowQuality", optional=true)
    protected static native NSString LowQualityValue();

    @GlobalValue(symbol="AVAssetExportPresetMediumQuality", optional=true)
    protected static native NSString MediumQualityValue();

    @GlobalValue(symbol="AVAssetExportPresetHighestQuality", optional=true)
    protected static native NSString HighestQualityValue();

    @GlobalValue(symbol="AVAssetExportPreset640x480", optional=true)
    protected static native NSString Size640x480Value();

    @GlobalValue(symbol="AVAssetExportPreset960x540", optional=true)
    protected static native NSString Size960x540Value();

    @GlobalValue(symbol="AVAssetExportPreset1280x720", optional=true)
    protected static native NSString Size1280x720Value();

    @GlobalValue(symbol="AVAssetExportPreset1920x1080", optional=true)
    protected static native NSString Size1920x1080Value();

    @GlobalValue(symbol="AVAssetExportPresetAppleM4A", optional=true)
    protected static native NSString AppleM4AValue();

    @GlobalValue(symbol="AVAssetExportPresetPassthrough", optional=true)
    protected static native NSString PassthroughValue();

    static {
        Bro.bind(AVAssetExportPreset.class);
        LowQuality = new AVAssetExportPreset("LowQualityValue");
        MediumQuality = new AVAssetExportPreset("MediumQualityValue");
        HighestQuality = new AVAssetExportPreset("HighestQualityValue");
        Size640x480 = new AVAssetExportPreset("Size640x480Value");
        Size960x540 = new AVAssetExportPreset("Size960x540Value");
        Size1280x720 = new AVAssetExportPreset("Size1280x720Value");
        Size1920x1080 = new AVAssetExportPreset("Size1920x1080Value");
        AppleM4A = new AVAssetExportPreset("AppleM4AValue");
        Passthrough = new AVAssetExportPreset("PassthroughValue");
        values = new AVAssetExportPreset[]{LowQuality, MediumQuality, HighestQuality, Size640x480, Size960x540, Size1280x720, Size1920x1080, AppleM4A, Passthrough};
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<AVAssetExportPreset> toObject(Class<? extends NSObject> cls, long handle, long flags) {
            NSArray o = (NSArray)NSObject.Marshaler.toObject(cls, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<AVAssetExportPreset> list = new ArrayList<AVAssetExportPreset>();
            for (NSString str : o) {
                list.add(AVAssetExportPreset.valueOf(str));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<AVAssetExportPreset> l, long flags) {
            if (l == null) {
                return 0L;
            }
            NSMutableArray<NSString> array = new NSMutableArray<NSString>();
            for (AVAssetExportPreset i : l) {
                array.add(i.value());
            }
            return NSObject.Marshaler.toNative(array, flags);
        }
    }

    public static class Marshaler {
        @MarshalsPointer
        public static AVAssetExportPreset toObject(Class<AVAssetExportPreset> cls, long handle, long flags) {
            NSString o = (NSString)NSObject.Marshaler.toObject(NSString.class, handle, flags);
            if (o == null) {
                return null;
            }
            return AVAssetExportPreset.valueOf(o);
        }

        @MarshalsPointer
        public static long toNative(AVAssetExportPreset o, long flags) {
            if (o == null) {
                return 0L;
            }
            return NSObject.Marshaler.toNative(o.value(), flags);
        }
    }
}

