/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.avfoundation;

import java.util.List;
import org.robovm.apple.avfoundation.AVAssetReferenceRestrictions;
import org.robovm.apple.avfoundation.AVAssetTrack;
import org.robovm.apple.avfoundation.AVAssetTrackGroup;
import org.robovm.apple.avfoundation.AVAsynchronousKeyValueLoading;
import org.robovm.apple.avfoundation.AVKeyValueStatus;
import org.robovm.apple.avfoundation.AVMediaCharacteristic;
import org.robovm.apple.avfoundation.AVMediaSelectionGroup;
import org.robovm.apple.avfoundation.AVMediaType;
import org.robovm.apple.avfoundation.AVMetadataFormat;
import org.robovm.apple.avfoundation.AVMetadataItem;
import org.robovm.apple.avfoundation.AVMetadataKey;
import org.robovm.apple.avfoundation.AVTimedMetadataGroup;
import org.robovm.apple.coregraphics.CGAffineTransform;
import org.robovm.apple.coremedia.CMTime;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSLocale;
import org.robovm.apple.foundation.NSObject;
import org.robovm.apple.foundation.NSURL;
import org.robovm.objc.ObjCRuntime;
import org.robovm.objc.annotation.Block;
import org.robovm.objc.annotation.Method;
import org.robovm.objc.annotation.NativeClass;
import org.robovm.objc.annotation.Property;
import org.robovm.rt.bro.annotation.ByVal;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.ptr.Ptr;

@Library(value="AVFoundation")
@NativeClass
public class AVAsset
extends NSObject
implements AVAsynchronousKeyValueLoading {
    public AVAsset() {
    }

    protected AVAsset(NSObject.SkipInit skipInit) {
        super(skipInit);
    }

    @Property(selector="duration")
    @ByVal
    public native CMTime getDuration();

    @Property(selector="preferredRate")
    public native float getPreferredRate();

    @Property(selector="preferredVolume")
    public native float getPreferredVolume();

    @Property(selector="preferredTransform")
    @ByVal
    public native CGAffineTransform getPreferredTransform();

    @Property(selector="providesPreciseDurationAndTiming")
    public native boolean providesPreciseDurationAndTiming();

    @Property(selector="referenceRestrictions")
    public native AVAssetReferenceRestrictions getReferenceRestrictions();

    @Property(selector="tracks")
    public native NSArray<AVAssetTrack> getTracks();

    @Property(selector="trackGroups")
    public native NSArray<AVAssetTrackGroup> getTrackGroups();

    @Property(selector="creationDate")
    public native AVMetadataItem getCreationDate();

    @Property(selector="lyrics")
    public native String getLyrics();

    @Property(selector="commonMetadata")
    public native NSArray<AVMetadataItem> getCommonMetadata();

    @Property(selector="metadata")
    public native NSArray<AVMetadataItem> getMetadata();

    @Property(selector="availableMetadataFormats")
    @Marshaler(value=AVMetadataFormat.AsListMarshaler.class)
    public native List<AVMetadataFormat> getAvailableMetadataFormats();

    @Property(selector="availableChapterLocales")
    public native NSArray<NSLocale> getAvailableChapterLocales();

    @Property(selector="availableMediaCharacteristicsWithMediaSelectionOptions")
    @Marshaler(value=AVMediaCharacteristic.AsListMarshaler.class)
    public native List<AVMediaCharacteristic> getAvailableMediaCharacteristicsWithMediaSelectionOptions();

    @Property(selector="hasProtectedContent")
    public native boolean hasProtectedContent();

    @Property(selector="isPlayable")
    public native boolean isPlayable();

    @Property(selector="isExportable")
    public native boolean isExportable();

    @Property(selector="isReadable")
    public native boolean isReadable();

    @Property(selector="isComposable")
    public native boolean isComposable();

    @Property(selector="isCompatibleWithSavedPhotosAlbum")
    public native boolean isCompatibleWithSavedPhotosAlbum();

    public AVKeyValueStatus getStatusOfValue(AVMetadataKey key) throws NSErrorException {
        NSError.NSErrorPtr err = new NSError.NSErrorPtr();
        AVKeyValueStatus result = this.getStatusOfValue(key, err);
        if (err.get() != null) {
            throw new NSErrorException((NSError)err.get());
        }
        return result;
    }

    @Method(selector="assetWithURL:")
    public static native AVAsset create(NSURL var0);

    @Method(selector="cancelLoading")
    public native void cancelLoading();

    @Method(selector="trackWithTrackID:")
    public native AVAssetTrack getTrack(int var1);

    @Method(selector="tracksWithMediaType:")
    public native NSArray<AVAssetTrack> getTracksWithType(AVMediaType var1);

    @Method(selector="tracksWithMediaCharacteristic:")
    public native NSArray<AVAssetTrack> getTracksWithCharacteristic(AVMediaCharacteristic var1);

    @Method(selector="metadataForFormat:")
    public native NSArray<AVMetadataItem> getMetadata(AVMetadataFormat var1);

    @Method(selector="chapterMetadataGroupsWithTitleLocale:containingItemsWithCommonKeys:")
    public native NSArray<AVTimedMetadataGroup> getChapterMetadataGroupsContainingItemsWithCommonKeys(NSLocale var1, @Marshaler(value=AVMetadataKey.AsListMarshaler.class) List<AVMetadataKey> var2);

    @Method(selector="chapterMetadataGroupsBestMatchingPreferredLanguages:")
    public native NSArray<AVTimedMetadataGroup> getChapterMetadataGroupsBestMatchingPreferredLanguages(@Marshaler(value=NSArray.AsStringListMarshaler.class) List<String> var1);

    @Method(selector="mediaSelectionGroupForMediaCharacteristic:")
    public native AVMediaSelectionGroup getMediaSelectionGroup(AVMediaCharacteristic var1);

    @Method(selector="unusedTrackID")
    public native int getUnusedTrackID();

    @Override
    @Method(selector="statusOfValueForKey:error:")
    public native AVKeyValueStatus getStatusOfValue(AVMetadataKey var1, NSError.NSErrorPtr var2);

    @Override
    @Method(selector="loadValuesAsynchronouslyForKeys:completionHandler:")
    public native void loadValuesAsynchronously(@Marshaler(value=AVMetadataKey.AsListMarshaler.class) List<AVMetadataKey> var1, @Block Runnable var2);

    static {
        ObjCRuntime.bind(AVAsset.class);
    }

    public static class AVAssetPtr
    extends Ptr<AVAsset, AVAssetPtr> {
    }
}

