/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiounit;

import org.robovm.apple.audiounit.AudioComponent;
import org.robovm.apple.audiounit.AudioComponentInstance;
import org.robovm.apple.audiounit.MusicDeviceNoteParams;
import org.robovm.apple.audiounit.MusicDeviceSelector;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.rt.VM;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.IntPtr;

@Library(value="AudioToolbox")
public class MusicDevice
extends AudioComponentInstance {
    public static MusicDevice create(AudioComponent component) throws OSStatusException {
        AudioComponentInstance result = AudioComponentInstance.create(component);
        if (result != null) {
            return (MusicDevice)result.as(MusicDevice.class);
        }
        return null;
    }

    public boolean canDo(MusicDeviceSelector inSelectorID) {
        return super.canDo((short)inSelectorID.value());
    }

    public void midiEvent(int status, int data1, int data2, int offsetSampleFrame) throws OSStatusException {
        OSStatus s = this.midiEvent0(status, data1, data2, offsetSampleFrame);
        OSStatusException.throwIfNecessary(s);
    }

    public void sysEx(byte[] data) throws OSStatusException {
        OSStatus status = this.sysEx0(VM.getArrayValuesAddress((Object)data), data.length);
        OSStatusException.throwIfNecessary(status);
    }

    public int startNote(int groupID, int offsetSampleFrame, MusicDeviceNoteParams params) throws OSStatusException {
        IntPtr result = new IntPtr();
        OSStatus status = this.startNote0(-1, groupID, result, offsetSampleFrame, params);
        OSStatusException.throwIfNecessary(status);
        return result.get();
    }

    public void stopNote(int groupID, int noteInstanceID, int offsetSampleFrame) throws OSStatusException {
        OSStatus status = this.stopNote0(groupID, noteInstanceID, offsetSampleFrame);
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="MusicDeviceMIDIEvent", optional=true)
    protected native OSStatus midiEvent0(int var1, int var2, int var3, int var4);

    @Bridge(symbol="MusicDeviceSysEx", optional=true)
    protected native OSStatus sysEx0(@Pointer long var1, int var3);

    @Bridge(symbol="MusicDeviceStartNote", optional=true)
    protected native OSStatus startNote0(int var1, int var2, IntPtr var3, int var4, MusicDeviceNoteParams var5);

    @Bridge(symbol="MusicDeviceStopNote", optional=true)
    protected native OSStatus stopNote0(int var1, int var2, int var3);

    static {
        Bro.bind(MusicDevice.class);
    }
}

