/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiounit;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiounit.AUAudioFilePlayerProperty;
import org.robovm.apple.audiounit.AUConnection;
import org.robovm.apple.audiounit.AUGenericProperty;
import org.robovm.apple.audiounit.AUHostCallback;
import org.robovm.apple.audiounit.AUHostCallbackInfo;
import org.robovm.apple.audiounit.AUInputSamplesInOutputCallback;
import org.robovm.apple.audiounit.AUInputSamplesInOutputCallbackStruct;
import org.robovm.apple.audiounit.AUMutableRenderActionFlags;
import org.robovm.apple.audiounit.AUOutputMIDICallback;
import org.robovm.apple.audiounit.AUOutputMIDICallbacksStruct;
import org.robovm.apple.audiounit.AUOutputProperty;
import org.robovm.apple.audiounit.AUOutputSelector;
import org.robovm.apple.audiounit.AUParameterType;
import org.robovm.apple.audiounit.AUPropertyListener;
import org.robovm.apple.audiounit.AUPropertyType;
import org.robovm.apple.audiounit.AURenderActionFlags;
import org.robovm.apple.audiounit.AURenderCallback;
import org.robovm.apple.audiounit.AURenderCallbackStruct;
import org.robovm.apple.audiounit.AUScheduledAudioFileRegion;
import org.robovm.apple.audiounit.AUScheduledAudioSlice;
import org.robovm.apple.audiounit.AUScheduledSoundPlayerProperty;
import org.robovm.apple.audiounit.AUScope;
import org.robovm.apple.audiounit.AUSelector;
import org.robovm.apple.audiounit.AudioComponent;
import org.robovm.apple.audiounit.AudioComponentDescription;
import org.robovm.apple.audiounit.AudioComponentInstance;
import org.robovm.apple.coreaudio.AudioBufferList;
import org.robovm.apple.coreaudio.AudioStreamBasicDescription;
import org.robovm.apple.coreaudio.AudioTimeStamp;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.uikit.UIImage;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.BooleanPtr;
import org.robovm.rt.bro.ptr.BytePtr;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioUnit
extends AudioComponentInstance {
    private static AtomicLong callbackId = new AtomicLong();
    private static LongMap<AUPropertyListener> propertyListeners = new LongMap();
    private static final Method cbPropertyChanged;
    private static LongMap<AURenderCallback> renderCallbacks;
    private static final Method cbRender;
    private static LongMap<AUHostCallback> hostCallbacks;
    private static final Method cbHostGetBeatAndTempo;
    private static final Method cbHostGetMusicalTimeLocation;
    private static final Method cbHostGetTransportState;
    private static final Method cbHostGetTransportState2;
    private static LongMap<AUInputSamplesInOutputCallback> isioCallbacks;
    private static final Method cbInputSamplesInOutput;
    private static LongMap<AUOutputMIDICallback> midiCallbacks;
    private static final Method cbMIDIEvent;
    private static final Method cbMIDISysEx;

    protected AudioUnit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPropertyChanged(@Pointer long refCon, AudioUnit unit, AUPropertyType id, AUScope scope, int element) {
        LongMap<AUPropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            ((AUPropertyListener)propertyListeners.get(refCon)).onChange(unit, id, scope, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbRender(@Pointer long refCon, AUMutableRenderActionFlags actionFlags, AudioTimeStamp timeStamp, int busNumber, int numberFrames, AudioBufferList data) {
        LongMap<AURenderCallback> longMap = renderCallbacks;
        synchronized (longMap) {
            OSStatus status = OSStatus.NO_ERR;
            try {
                ((AURenderCallback)renderCallbacks.get(refCon)).onRender(actionFlags, timeStamp, busNumber, numberFrames, data);
            }
            catch (OSStatusException e) {
                status = e.getStatus();
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbHostGetBeatAndTempo(@Pointer long userData, DoublePtr currentBeat, DoublePtr currentTempo) {
        LongMap<AUHostCallback> longMap = hostCallbacks;
        synchronized (longMap) {
            return ((AUHostCallback)hostCallbacks.get(userData)).getBeatAndTempo(currentBeat, currentTempo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbHostGetMusicalTimeLocation(@Pointer long userData, IntPtr deltaSampleOffsetToNextBeat, FloatPtr timeSigNumerator, IntPtr timeSigDenominator, DoublePtr currentMeasureDownBeat) {
        LongMap<AUHostCallback> longMap = hostCallbacks;
        synchronized (longMap) {
            return ((AUHostCallback)hostCallbacks.get(userData)).getMusicalTimeLocation(deltaSampleOffsetToNextBeat, timeSigNumerator, timeSigDenominator, currentMeasureDownBeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbHostGetTransportState(@Pointer long userData, BooleanPtr isPlaying, BooleanPtr transportStateChanged, DoublePtr currentSampleInTimeLine, BooleanPtr isCycling, DoublePtr cycleStartBeat, DoublePtr cycleEndBeat) {
        LongMap<AUHostCallback> longMap = hostCallbacks;
        synchronized (longMap) {
            return ((AUHostCallback)hostCallbacks.get(userData)).getTransportState(isPlaying, transportStateChanged, currentSampleInTimeLine, isCycling, cycleStartBeat, cycleEndBeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static OSStatus cbHostGetTransportState(@Pointer long userData, BooleanPtr isPlaying, BooleanPtr isRecording, BooleanPtr transportStateChanged, DoublePtr currentSampleInTimeLine, BooleanPtr isCycling, DoublePtr cycleStartBeat, DoublePtr cycleEndBeat) {
        LongMap<AUHostCallback> longMap = hostCallbacks;
        synchronized (longMap) {
            return ((AUHostCallback)hostCallbacks.get(userData)).getTransportState2(isPlaying, isRecording, transportStateChanged, currentSampleInTimeLine, isCycling, cycleStartBeat, cycleEndBeat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInputSamplesInOutput(@Pointer long refCon, AudioTimeStamp outputTimeStamp, double inputSample, double numberInputSamples) {
        LongMap<AUInputSamplesInOutputCallback> longMap = isioCallbacks;
        synchronized (longMap) {
            ((AUInputSamplesInOutputCallback)isioCallbacks.get(refCon)).invoke(outputTimeStamp, inputSample, numberInputSamples);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbMIDIEvent(@Pointer long userData, int status, int data1, int data2, int offsetSampleFrame) {
        LongMap<AUOutputMIDICallback> longMap = midiCallbacks;
        synchronized (longMap) {
            ((AUOutputMIDICallback)midiCallbacks.get(userData)).onMIDIEvent(status, data1, data2, offsetSampleFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbMIDISysEx(@Pointer long userData, BytePtr data, int length) {
        LongMap<AUOutputMIDICallback> longMap = midiCallbacks;
        synchronized (longMap) {
            ((AUOutputMIDICallback)midiCallbacks.get(userData)).onMIDISysEx(data.toByteArray(length));
        }
    }

    public static AudioUnit create(AudioComponent component) throws OSStatusException {
        AudioComponentInstance result = AudioComponentInstance.create(component);
        if (result != null) {
            return (AudioUnit)result.as(AudioUnit.class);
        }
        return null;
    }

    public boolean canDo(AUSelector selector) {
        return super.canDo((short)selector.value());
    }

    public boolean canDo(AUOutputSelector selector) {
        return super.canDo((short)selector.value());
    }

    public void initialize() throws OSStatusException {
        OSStatus status = this.initialize0();
        OSStatusException.throwIfNecessary(status);
    }

    public void uninitialize() throws OSStatusException {
        OSStatus status = this.uninitialize0();
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertySize(AUPropertyType type, AUScope scope) throws OSStatusException {
        return this.getPropertySize(type, scope, 0);
    }

    public int getPropertySize(AUPropertyType type, AUScope scope, int element) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getPropertyInfo0(type, scope, element, ptr, null);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public boolean isPropertyWritable(AUPropertyType type, AUScope scope) throws OSStatusException {
        return this.isPropertyWritable(type, scope, 0);
    }

    public boolean isPropertyWritable(AUPropertyType type, AUScope scope, int element) throws OSStatusException {
        BooleanPtr ptr = new BooleanPtr();
        OSStatus status = this.getPropertyInfo0(type, scope, element, null, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public <T extends Struct<T>> T getProperty(AUPropertyType type, Class<T> returnType, AUScope scope) throws OSStatusException {
        return this.getProperty(type, returnType, scope, 0);
    }

    public <T extends Struct<T>> T getProperty(AUPropertyType type, Class<T> returnType, AUScope scope, int element) throws OSStatusException {
        Struct data = Struct.allocate(returnType);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(type, scope, element, (VoidPtr)data.as(VoidPtr.class), dataSize);
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(AUPropertyType type, Struct<T> data, AUScope scope) throws OSStatusException {
        this.setProperty(type, data, scope, 0);
    }

    public <T extends Struct<T>> void setProperty(AUPropertyType type, Struct<T> data, AUScope scope, int element) throws OSStatusException {
        OSStatus status = this.setProperty0(type, scope, element, data == null ? null : (VoidPtr)data.as(VoidPtr.class), data == null ? 0 : Struct.sizeOf(data));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(AUPropertyType type, AUScope scope) throws OSStatusException {
        IntPtr ptr = this.getProperty(type, IntPtr.class, scope);
        return ptr.get();
    }

    public long getPropertyAsLong(AUPropertyType type, AUScope scope) throws OSStatusException {
        LongPtr ptr = this.getProperty(type, LongPtr.class, scope);
        return ptr.get();
    }

    public float getPropertyAsFloat(AUPropertyType type, AUScope scope) throws OSStatusException {
        FloatPtr ptr = this.getProperty(type, FloatPtr.class, scope);
        return ptr.get();
    }

    public double getPropertyAsDouble(AUPropertyType type, AUScope scope) throws OSStatusException {
        DoublePtr ptr = this.getProperty(type, DoublePtr.class, scope);
        return ptr.get();
    }

    public void setProperty(AUPropertyType type, int value, AUScope scope) throws OSStatusException {
        this.setProperty(type, (Struct)new IntPtr(value), scope);
    }

    public void setProperty(AUPropertyType type, long value, AUScope scope) throws OSStatusException {
        this.setProperty(type, (Struct)new LongPtr(value), scope);
    }

    public void setProperty(AUPropertyType type, float value, AUScope scope) throws OSStatusException {
        this.setProperty(type, (Struct)new FloatPtr(value), scope);
    }

    public void setProperty(AUPropertyType type, double value, AUScope scope) throws OSStatusException {
        this.setProperty(type, (Struct)new DoublePtr(value), scope);
    }

    public int getMaxFramesPerSlice(AUScope scope) throws OSStatusException {
        return this.getPropertyAsInt(AUGenericProperty.MaximumFramesPerSlice, scope);
    }

    public void setMaxFramesPerSlice(int maxFramesPerSlice, AUScope scope) throws OSStatusException {
        this.setProperty((AUPropertyType)AUGenericProperty.MaximumFramesPerSlice, maxFramesPerSlice, scope);
    }

    public AudioStreamBasicDescription getStreamFormat(AUScope scope) throws OSStatusException {
        return this.getProperty(AUGenericProperty.StreamFormat, AudioStreamBasicDescription.class, scope);
    }

    public void setStreamFormat(AudioStreamBasicDescription streamFormat, AUScope scope) throws OSStatusException {
        this.setProperty((AUPropertyType)AUGenericProperty.StreamFormat, streamFormat, scope);
    }

    public void makeConnection(AUConnection connection, AUScope scope) throws OSStatusException {
        this.setProperty((AUPropertyType)AUGenericProperty.MakeConnection, connection, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderCallback(AURenderCallback callback, AUScope scope) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        AURenderCallbackStruct struct = new AURenderCallbackStruct(new FunctionPtr(cbRender), cid);
        this.setProperty((AUPropertyType)AUGenericProperty.SetRenderCallback, struct, scope);
        LongMap<AURenderCallback> longMap = renderCallbacks;
        synchronized (longMap) {
            renderCallbacks.put(cid, (Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostCallback(AUHostCallback callback, AUScope scope) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        AUHostCallbackInfo struct = new AUHostCallbackInfo(cid, new FunctionPtr(cbHostGetBeatAndTempo), new FunctionPtr(cbHostGetMusicalTimeLocation), new FunctionPtr(cbHostGetTransportState), new FunctionPtr(cbHostGetTransportState2));
        this.setProperty((AUPropertyType)AUGenericProperty.HostCallbacks, struct, scope);
        LongMap<AUHostCallback> longMap = hostCallbacks;
        synchronized (longMap) {
            hostCallbacks.put(cid, (Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AUInputSamplesInOutputCallback getInputSamplesInOutputCallback(AUScope scope) throws OSStatusException {
        AUInputSamplesInOutputCallbackStruct struct = this.getProperty(AUGenericProperty.InputSamplesInOutput, AUInputSamplesInOutputCallbackStruct.class, scope);
        AUInputSamplesInOutputCallback result = null;
        if (struct != null) {
            LongMap<AUInputSamplesInOutputCallback> longMap = isioCallbacks;
            synchronized (longMap) {
                result = (AUInputSamplesInOutputCallback)isioCallbacks.get(struct.getUserData());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputSamplesInOutputCallback(AUInputSamplesInOutputCallback callback, AUScope scope) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        AUInputSamplesInOutputCallbackStruct struct = new AUInputSamplesInOutputCallbackStruct(new FunctionPtr(cbInputSamplesInOutput), cid);
        this.setProperty((AUPropertyType)AUGenericProperty.InputSamplesInOutput, struct, scope);
        LongMap<AUInputSamplesInOutputCallback> longMap = isioCallbacks;
        synchronized (longMap) {
            isioCallbacks.put(cid, (Object)callback);
        }
    }

    public void scheduleAudioSlice(AUScheduledAudioSlice slice, AUScope scope) throws OSStatusException {
        this.setProperty((AUPropertyType)AUScheduledSoundPlayerProperty.ScheduleAudioSlice, slice, scope);
    }

    public void scheduleAudioFileRegion(AUScheduledAudioFileRegion region, AUScope scope) throws OSStatusException {
        this.setProperty((AUPropertyType)AUAudioFilePlayerProperty.ScheduledFileRegion, region, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AUOutputMIDICallback getMIDICallbacks(AUScope scope) throws OSStatusException {
        AUOutputMIDICallbacksStruct struct = this.getProperty(AUOutputProperty.MIDICallbacks, AUOutputMIDICallbacksStruct.class, scope);
        AUOutputMIDICallback result = null;
        if (struct != null) {
            LongMap<AUOutputMIDICallback> longMap = midiCallbacks;
            synchronized (longMap) {
                result = (AUOutputMIDICallback)midiCallbacks.get(struct.getUserData());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMIDICallbacks(AUOutputMIDICallback callback, AUScope scope) throws OSStatusException {
        AUOutputMIDICallbacksStruct struct = null;
        if (callback == null) {
            struct = this.getProperty(AUOutputProperty.MIDICallbacks, AUOutputMIDICallbacksStruct.class, scope);
            if (struct != null) {
                this.setProperty((AUPropertyType)AUOutputProperty.MIDICallbacks, null, scope);
                LongMap<AUOutputMIDICallback> longMap = midiCallbacks;
                synchronized (longMap) {
                    midiCallbacks.remove(struct.getUserData());
                }
            }
        } else {
            long cid = callbackId.getAndIncrement();
            struct = new AUOutputMIDICallbacksStruct(cid, new FunctionPtr(cbMIDIEvent), new FunctionPtr(cbMIDISysEx));
            this.setProperty((AUPropertyType)AUOutputProperty.MIDICallbacks, struct, scope);
            LongMap<AUOutputMIDICallback> longMap = midiCallbacks;
            synchronized (longMap) {
                midiCallbacks.put(cid, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyListener(AUPropertyType id, AUPropertyListener listener) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        OSStatus status = this.addPropertyListener0(id, new FunctionPtr(cbPropertyChanged), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<AUPropertyListener> longMap = propertyListeners;
            synchronized (longMap) {
                propertyListeners.put(cid, (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyListener(AUPropertyType id, AUPropertyListener listener) throws OSStatusException {
        LongMap<AUPropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            for (LongMap.Entry entry : propertyListeners.entries()) {
                if (entry.value != listener) continue;
                OSStatus status = this.removePropertyListener0(id, new FunctionPtr(cbPropertyChanged), entry.key);
                OSStatusException.throwIfNecessary(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRenderNotify(AURenderCallback callback) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        OSStatus status = this.addRenderNotify0(new FunctionPtr(cbRender), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<AURenderCallback> longMap = renderCallbacks;
            synchronized (longMap) {
                renderCallbacks.put(cid, (Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderNotify(AURenderCallback callback) throws OSStatusException {
        LongMap<AURenderCallback> longMap = renderCallbacks;
        synchronized (longMap) {
            for (LongMap.Entry entry : renderCallbacks.entries()) {
                if (entry.value != callback) continue;
                OSStatus status = this.removeRenderNotify0(new FunctionPtr(cbRender), entry.key);
                OSStatusException.throwIfNecessary(status);
            }
        }
    }

    public float getParameter(AUParameterType type, AUScope scope) throws OSStatusException {
        return this.getParameter(type, scope, 0);
    }

    public float getParameter(AUParameterType type, AUScope scope, int element) throws OSStatusException {
        FloatPtr ptr = new FloatPtr();
        OSStatus status = this.getParameter0(type, scope, element, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public void setParameter(AUParameterType type, float value, AUScope scope) throws OSStatusException {
        this.setParameter(type, value, scope, 0, 0);
    }

    public void setParameter(AUParameterType type, float value, AUScope scope, int element, int bufferOffsetInFrames) throws OSStatusException {
        OSStatus status = this.setParameter0(type, scope, element, value, bufferOffsetInFrames);
        OSStatusException.throwIfNecessary(status);
    }

    public void render(AURenderActionFlags actionFlags, AudioTimeStamp timeStamp, int outputBusNumber, int numberFrames, AudioBufferList data) throws OSStatusException {
        this.render(new AUMutableRenderActionFlags(actionFlags), timeStamp, outputBusNumber, numberFrames, data);
    }

    public void render(AUMutableRenderActionFlags actionFlags, AudioTimeStamp timeStamp, int outputBusNumber, int numberFrames, AudioBufferList data) throws OSStatusException {
        OSStatus status = this.render0(actionFlags, timeStamp, outputBusNumber, numberFrames, data);
        OSStatusException.throwIfNecessary(status);
    }

    public void process(AUMutableRenderActionFlags actionFlags, AudioTimeStamp timeStamp, int numberFrames, AudioBufferList data) throws OSStatusException {
        OSStatus status = this.process0(actionFlags, timeStamp, numberFrames, data);
        OSStatusException.throwIfNecessary(status);
    }

    public void reset(AUScope scope, int element) throws OSStatusException {
        OSStatus status = this.reset0(scope, element);
        OSStatusException.throwIfNecessary(status);
    }

    public void publishOutput(AudioComponentDescription desc, String name, int version) throws OSStatusException {
        OSStatus status = AudioUnit.publishOutput0(desc, name, version, this);
        OSStatusException.throwIfNecessary(status);
    }

    public void startOutput() throws OSStatusException {
        OSStatus status = this.startOutput0();
        OSStatusException.throwIfNecessary(status);
    }

    public void stopOutput() throws OSStatusException {
        OSStatus status = this.stopOutput0();
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="AudioUnitInitialize", optional=true)
    protected native OSStatus initialize0();

    @Bridge(symbol="AudioUnitUninitialize", optional=true)
    protected native OSStatus uninitialize0();

    @Bridge(symbol="AudioUnitGetPropertyInfo", optional=true)
    protected native OSStatus getPropertyInfo0(AUPropertyType var1, AUScope var2, int var3, IntPtr var4, BooleanPtr var5);

    @Bridge(symbol="AudioUnitGetProperty", optional=true)
    protected native OSStatus getProperty0(AUPropertyType var1, AUScope var2, int var3, VoidPtr var4, IntPtr var5);

    @Bridge(symbol="AudioUnitSetProperty", optional=true)
    protected native OSStatus setProperty0(AUPropertyType var1, AUScope var2, int var3, VoidPtr var4, int var5);

    @Bridge(symbol="AudioUnitAddPropertyListener", optional=true)
    protected native OSStatus addPropertyListener0(AUPropertyType var1, FunctionPtr var2, @Pointer long var3);

    @Bridge(symbol="AudioUnitRemovePropertyListenerWithUserData", optional=true)
    protected native OSStatus removePropertyListener0(AUPropertyType var1, FunctionPtr var2, @Pointer long var3);

    @Bridge(symbol="AudioUnitAddRenderNotify", optional=true)
    protected native OSStatus addRenderNotify0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="AudioUnitRemoveRenderNotify", optional=true)
    protected native OSStatus removeRenderNotify0(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="AudioUnitGetParameter", optional=true)
    protected native OSStatus getParameter0(AUParameterType var1, AUScope var2, int var3, FloatPtr var4);

    @Bridge(symbol="AudioUnitSetParameter", optional=true)
    protected native OSStatus setParameter0(AUParameterType var1, AUScope var2, int var3, float var4, int var5);

    @Bridge(symbol="AudioUnitRender", optional=true)
    protected native OSStatus render0(AUMutableRenderActionFlags var1, AudioTimeStamp var2, int var3, int var4, AudioBufferList var5);

    @Bridge(symbol="AudioUnitProcess", optional=true)
    protected native OSStatus process0(AUMutableRenderActionFlags var1, AudioTimeStamp var2, int var3, AudioBufferList var4);

    @Bridge(symbol="AudioUnitProcessMultiple", optional=true)
    protected native OSStatus processMultiple0(AUMutableRenderActionFlags var1, AudioTimeStamp var2, int var3, int var4, AudioBufferList.AudioBufferListPtr var5, int var6, AudioBufferList.AudioBufferListPtr var7);

    @Bridge(symbol="AudioUnitReset", optional=true)
    protected native OSStatus reset0(AUScope var1, int var2);

    @Bridge(symbol="AudioOutputUnitPublish", optional=true)
    protected static native OSStatus publishOutput0(AudioComponentDescription var0, String var1, int var2, AudioUnit var3);

    @Bridge(symbol="AudioOutputUnitGetHostIcon", optional=true)
    public native UIImage getOutputHostIcon(float var1);

    @Bridge(symbol="AudioOutputUnitStart", optional=true)
    protected native OSStatus startOutput0();

    @Bridge(symbol="AudioOutputUnitStop", optional=true)
    protected native OSStatus stopOutput0();

    static {
        renderCallbacks = new LongMap();
        hostCallbacks = new LongMap();
        isioCallbacks = new LongMap();
        try {
            cbPropertyChanged = AudioUnit.class.getDeclaredMethod("cbPropertyChanged", Long.TYPE, AudioUnit.class, AUPropertyType.class, AUScope.class, Integer.TYPE);
            cbRender = AudioUnit.class.getDeclaredMethod("cbRender", Long.TYPE, AUMutableRenderActionFlags.class, AudioTimeStamp.class, Integer.TYPE, Integer.TYPE, AudioBufferList.class);
            cbHostGetBeatAndTempo = AudioUnit.class.getDeclaredMethod("cbHostGetBeatAndTempo", Long.TYPE, DoublePtr.class, DoublePtr.class);
            cbHostGetMusicalTimeLocation = AudioUnit.class.getDeclaredMethod("cbHostGetMusicalTimeLocation", Long.TYPE, IntPtr.class, FloatPtr.class, IntPtr.class, DoublePtr.class);
            cbHostGetTransportState = AudioUnit.class.getDeclaredMethod("cbHostGetTransportState", Long.TYPE, BooleanPtr.class, BooleanPtr.class, DoublePtr.class, BooleanPtr.class, DoublePtr.class, DoublePtr.class);
            cbHostGetTransportState2 = AudioUnit.class.getDeclaredMethod("cbHostGetTransportState", Long.TYPE, BooleanPtr.class, BooleanPtr.class, BooleanPtr.class, DoublePtr.class, BooleanPtr.class, DoublePtr.class, DoublePtr.class);
            cbInputSamplesInOutput = AudioUnit.class.getDeclaredMethod("cbInputSamplesInOutput", Long.TYPE, AudioTimeStamp.class, Double.TYPE, Double.TYPE);
            cbMIDIEvent = AudioUnit.class.getDeclaredMethod("cbMIDIEvent", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            cbMIDISysEx = AudioUnit.class.getDeclaredMethod("cbMIDISysEx", Long.TYPE, BytePtr.class, Integer.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioUnit.class);
    }

    public static class AudioUnitPtr
    extends Ptr<AudioUnit, AudioUnitPtr> {
    }
}

