/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import org.robovm.apple.audiotoolbox.AUParameterEvent;
import org.robovm.apple.audiotoolbox.AUPresetEvent;
import org.robovm.apple.audiotoolbox.ExtendedNoteOnEvent;
import org.robovm.apple.audiotoolbox.MIDIChannelMessage;
import org.robovm.apple.audiotoolbox.MIDIMetaEvent;
import org.robovm.apple.audiotoolbox.MIDINoteMessage;
import org.robovm.apple.audiotoolbox.MIDIRawData;
import org.robovm.apple.audiotoolbox.MusicEventUserData;
import org.robovm.apple.audiotoolbox.MusicSequence;
import org.robovm.apple.audiotoolbox.MusicTrackProperty;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.coremidi.MIDIEndpoint;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.Ptr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class MusicTrack
extends NativeObject {
    protected MusicTrack() {
    }

    public MusicSequence getSequence() throws OSStatusException {
        MusicSequence.MusicSequencePtr ptr = new MusicSequence.MusicSequencePtr();
        OSStatus status = this.getSequence0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MusicSequence)ptr.get();
    }

    public void setDestNode(int node) throws OSStatusException {
        OSStatus status = this.setDestNode0(node);
        OSStatusException.throwIfNecessary(status);
    }

    public void setDestMIDIEndpoint(MIDIEndpoint endpoint) throws OSStatusException {
        OSStatus status = this.setDestMIDIEndpoint0(endpoint);
        OSStatusException.throwIfNecessary(status);
    }

    public int getDestNode() throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = this.getDestNode0(ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    public MIDIEndpoint getDestMIDIEndpoint() throws OSStatusException {
        MIDIEndpoint.MIDIEndpointPtr ptr = new MIDIEndpoint.MIDIEndpointPtr();
        OSStatus status = this.getDestMIDIEndpoint0(ptr);
        OSStatusException.throwIfNecessary(status);
        return (MIDIEndpoint)ptr.get();
    }

    public <T extends Struct<T>> T getProperty(MusicTrackProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = this.getProperty0(id, (VoidPtr)data.as(VoidPtr.class), dataSize);
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    public <T extends Struct<T>> void setProperty(MusicTrackProperty id, T data) throws OSStatusException {
        OSStatus status = this.setProperty0(id, data == null ? null : (VoidPtr)data.as(VoidPtr.class), data == null ? 0 : Struct.sizeOf(data));
        OSStatusException.throwIfNecessary(status);
    }

    public int getPropertyAsInt(MusicTrackProperty id) throws OSStatusException {
        IntPtr ptr = this.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    public long getPropertyAsLong(MusicTrackProperty id) throws OSStatusException {
        LongPtr ptr = this.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    public float getPropertyAsFloat(MusicTrackProperty id) throws OSStatusException {
        FloatPtr ptr = this.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    public double getPropertyAsDouble(MusicTrackProperty id) throws OSStatusException {
        DoublePtr ptr = this.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    public void setProperty(MusicTrackProperty id, int value) throws OSStatusException {
        this.setProperty(id, new IntPtr(value));
    }

    public void setProperty(MusicTrackProperty id, long value) throws OSStatusException {
        this.setProperty(id, new LongPtr(value));
    }

    public void setProperty(MusicTrackProperty id, float value) throws OSStatusException {
        this.setProperty(id, new FloatPtr(value));
    }

    public void setProperty(MusicTrackProperty id, double value) throws OSStatusException {
        this.setProperty(id, new DoublePtr(value));
    }

    public void moveEvents(double startTime, double endTime, double moveTime) throws OSStatusException {
        OSStatus status = this.moveEvents0(startTime, endTime, moveTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void clear(double startTime, double endTime) throws OSStatusException {
        OSStatus status = this.clear0(startTime, endTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void cut(double startTime, double endTime) throws OSStatusException {
        OSStatus status = this.cut0(startTime, endTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void copyInsert(double sourceStartTime, double sourceEndTime, MusicTrack destTrack, double destInsertTime) throws OSStatusException {
        OSStatus status = this.copyInsert0(sourceStartTime, sourceEndTime, destTrack, destInsertTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void merge(double sourceStartTime, double sourceEndTime, MusicTrack destTrack, double destInsertTime) throws OSStatusException {
        OSStatus status = this.merge0(sourceStartTime, sourceEndTime, destTrack, destInsertTime);
        OSStatusException.throwIfNecessary(status);
    }

    public void newMIDINoteEvent(double timeStamp, MIDINoteMessage message) throws OSStatusException {
        OSStatus status = this.newMIDINoteEvent0(timeStamp, message);
        OSStatusException.throwIfNecessary(status);
    }

    public void newMIDIChannelEvent(double timeStamp, MIDIChannelMessage message) throws OSStatusException {
        OSStatus status = this.newMIDIChannelEvent0(timeStamp, message);
        OSStatusException.throwIfNecessary(status);
    }

    public void newMIDIRawDataEvent(double timeStamp, MIDIRawData rawData) throws OSStatusException {
        OSStatus status = this.newMIDIRawDataEvent0(timeStamp, rawData);
        OSStatusException.throwIfNecessary(status);
    }

    public void newExtendedNoteEvent(double timeStamp, ExtendedNoteOnEvent info) throws OSStatusException {
        OSStatus status = this.newExtendedNoteEvent0(timeStamp, info);
        OSStatusException.throwIfNecessary(status);
    }

    public void newParameterEvent(double timeStamp, AUParameterEvent info) throws OSStatusException {
        OSStatus status = this.newParameterEvent0(timeStamp, info);
        OSStatusException.throwIfNecessary(status);
    }

    public void newExtendedTempoEvent(double timeStamp, double bpm) throws OSStatusException {
        OSStatus status = this.newExtendedTempoEvent0(timeStamp, bpm);
        OSStatusException.throwIfNecessary(status);
    }

    public void newMetaEvent(double timeStamp, MIDIMetaEvent metaEvent) throws OSStatusException {
        OSStatus status = this.newMetaEvent0(timeStamp, metaEvent);
        OSStatusException.throwIfNecessary(status);
    }

    public void newUserEvent(double timeStamp, MusicEventUserData userData) throws OSStatusException {
        OSStatus status = this.newUserEvent0(timeStamp, userData);
        OSStatusException.throwIfNecessary(status);
    }

    public void newAUPresetEvent(double timeStamp, AUPresetEvent presetEvent) throws OSStatusException {
        OSStatus status = this.newAUPresetEvent0(timeStamp, presetEvent);
        OSStatusException.throwIfNecessary(status);
    }

    @Bridge(symbol="MusicTrackGetSequence", optional=true)
    protected native OSStatus getSequence0(MusicSequence.MusicSequencePtr var1);

    @Bridge(symbol="MusicTrackSetDestNode", optional=true)
    protected native OSStatus setDestNode0(int var1);

    @Bridge(symbol="MusicTrackSetDestMIDIEndpoint", optional=true)
    protected native OSStatus setDestMIDIEndpoint0(MIDIEndpoint var1);

    @Bridge(symbol="MusicTrackGetDestNode", optional=true)
    protected native OSStatus getDestNode0(IntPtr var1);

    @Bridge(symbol="MusicTrackGetDestMIDIEndpoint", optional=true)
    protected native OSStatus getDestMIDIEndpoint0(MIDIEndpoint.MIDIEndpointPtr var1);

    @Bridge(symbol="MusicTrackSetProperty", optional=true)
    protected native OSStatus setProperty0(MusicTrackProperty var1, VoidPtr var2, int var3);

    @Bridge(symbol="MusicTrackGetProperty", optional=true)
    protected native OSStatus getProperty0(MusicTrackProperty var1, VoidPtr var2, IntPtr var3);

    @Bridge(symbol="MusicTrackMoveEvents", optional=true)
    protected native OSStatus moveEvents0(double var1, double var3, double var5);

    @Bridge(symbol="MusicTrackClear", optional=true)
    protected native OSStatus clear0(double var1, double var3);

    @Bridge(symbol="MusicTrackCut", optional=true)
    protected native OSStatus cut0(double var1, double var3);

    @Bridge(symbol="MusicTrackCopyInsert", optional=true)
    protected native OSStatus copyInsert0(double var1, double var3, MusicTrack var5, double var6);

    @Bridge(symbol="MusicTrackMerge", optional=true)
    protected native OSStatus merge0(double var1, double var3, MusicTrack var5, double var6);

    @Bridge(symbol="MusicTrackNewMIDINoteEvent", optional=true)
    protected native OSStatus newMIDINoteEvent0(double var1, MIDINoteMessage var3);

    @Bridge(symbol="MusicTrackNewMIDIChannelEvent", optional=true)
    protected native OSStatus newMIDIChannelEvent0(double var1, MIDIChannelMessage var3);

    @Bridge(symbol="MusicTrackNewMIDIRawDataEvent", optional=true)
    protected native OSStatus newMIDIRawDataEvent0(double var1, MIDIRawData var3);

    @Bridge(symbol="MusicTrackNewExtendedNoteEvent", optional=true)
    protected native OSStatus newExtendedNoteEvent0(double var1, ExtendedNoteOnEvent var3);

    @Bridge(symbol="MusicTrackNewParameterEvent", optional=true)
    protected native OSStatus newParameterEvent0(double var1, AUParameterEvent var3);

    @Bridge(symbol="MusicTrackNewExtendedTempoEvent", optional=true)
    protected native OSStatus newExtendedTempoEvent0(double var1, double var3);

    @Bridge(symbol="MusicTrackNewMetaEvent", optional=true)
    protected native OSStatus newMetaEvent0(double var1, MIDIMetaEvent var3);

    @Bridge(symbol="MusicTrackNewUserEvent", optional=true)
    protected native OSStatus newUserEvent0(double var1, MusicEventUserData var3);

    @Bridge(symbol="MusicTrackNewAUPresetEvent", optional=true)
    protected native OSStatus newAUPresetEvent0(double var1, AUPresetEvent var3);

    static {
        Bro.bind(MusicTrack.class);
    }

    public static class MusicTrackPtr
    extends Ptr<MusicTrack, MusicTrackPtr> {
    }
}

