/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.audiotoolbox;

import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.audiotoolbox.AudioSessionActivationFlags;
import org.robovm.apple.audiotoolbox.AudioSessionInterruptionState;
import org.robovm.apple.audiotoolbox.AudioSessionProperty;
import org.robovm.apple.corefoundation.OSStatus;
import org.robovm.apple.corefoundation.OSStatusException;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSRunLoop;
import org.robovm.apple.foundation.NSRunLoopMode;
import org.robovm.objc.LongMap;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.Struct;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.DoublePtr;
import org.robovm.rt.bro.ptr.FloatPtr;
import org.robovm.rt.bro.ptr.FunctionPtr;
import org.robovm.rt.bro.ptr.IntPtr;
import org.robovm.rt.bro.ptr.LongPtr;
import org.robovm.rt.bro.ptr.VoidPtr;

@Library(value="AudioToolbox")
public class AudioSession
extends CocoaUtility {
    private static AtomicLong callbackId = new AtomicLong();
    private static final LongMap<PropertyListener> propertyListeners = new LongMap();
    private static final Method cbPropertyChanged;
    private static final LongMap<InterruptionListener> interruptionListeners;
    private static final Method cbInterruption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbPropertyChanged(@Pointer long clientData, AudioSessionProperty id, int dataSize, VoidPtr data) {
        LongMap<PropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            ((PropertyListener)propertyListeners.get(clientData)).onChange(id, dataSize, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbInterruption(@Pointer long clientData, AudioSessionInterruptionState interruptionState) {
        LongMap<InterruptionListener> longMap = interruptionListeners;
        synchronized (longMap) {
            ((InterruptionListener)interruptionListeners.get(clientData)).onInterrupt(interruptionState);
        }
    }

    @Deprecated
    public static void initialize(NSRunLoop runLoop, NSRunLoopMode runLoopMode, InterruptionListener interruptionListener) throws OSStatusException {
        AudioSession.initialize(runLoop, runLoopMode == null ? null : runLoopMode.value(), interruptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void initialize(NSRunLoop runLoop, String runLoopMode, InterruptionListener interruptionListener) throws OSStatusException {
        if (interruptionListener == null) {
            OSStatus status = AudioSession.initialize0(runLoop, runLoopMode, null, 0L);
            OSStatusException.throwIfNecessary(status);
            return;
        }
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioSession.initialize0(runLoop, runLoopMode, new FunctionPtr(cbInterruption), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<InterruptionListener> longMap = interruptionListeners;
            synchronized (longMap) {
                interruptionListeners.put(cid, (Object)interruptionListener);
            }
        }
    }

    @Deprecated
    public static void setActive(boolean active) throws OSStatusException {
        OSStatus status = AudioSession.setActive0(active);
        OSStatusException.throwIfNecessary(status);
    }

    @Deprecated
    public static void setActive(boolean active, AudioSessionActivationFlags flags) throws OSStatusException {
        OSStatus status = AudioSession.setActive0(active, flags);
        OSStatusException.throwIfNecessary(status);
    }

    @Deprecated
    public static <T extends Struct<T>> T getProperty(AudioSessionProperty id, Class<T> type) throws OSStatusException {
        Struct data = Struct.allocate(type);
        IntPtr dataSize = new IntPtr(Struct.sizeOf((Struct)data));
        OSStatus status = AudioSession.getProperty0(id, dataSize, (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
        return (T)data;
    }

    @Deprecated
    public static <T extends Struct<T>> void setProperty(AudioSessionProperty id, T data) throws OSStatusException {
        OSStatus status = AudioSession.setProperty0(id, data == null ? 0 : Struct.sizeOf(data), data == null ? null : (VoidPtr)data.as(VoidPtr.class));
        OSStatusException.throwIfNecessary(status);
    }

    @Deprecated
    public static int getPropertyAsInt(AudioSessionProperty id) throws OSStatusException {
        IntPtr ptr = AudioSession.getProperty(id, IntPtr.class);
        return ptr.get();
    }

    @Deprecated
    public static long getPropertyAsLong(AudioSessionProperty id) throws OSStatusException {
        LongPtr ptr = AudioSession.getProperty(id, LongPtr.class);
        return ptr.get();
    }

    @Deprecated
    public static float getPropertyAsFloat(AudioSessionProperty id) throws OSStatusException {
        FloatPtr ptr = AudioSession.getProperty(id, FloatPtr.class);
        return ptr.get();
    }

    @Deprecated
    public static double getPropertyAsDouble(AudioSessionProperty id) throws OSStatusException {
        DoublePtr ptr = AudioSession.getProperty(id, DoublePtr.class);
        return ptr.get();
    }

    @Deprecated
    public static void setProperty(AudioSessionProperty id, int value) throws OSStatusException {
        AudioSession.setProperty(id, new IntPtr(value));
    }

    @Deprecated
    public static void setProperty(AudioSessionProperty id, long value) throws OSStatusException {
        AudioSession.setProperty(id, new LongPtr(value));
    }

    @Deprecated
    public static void setProperty(AudioSessionProperty id, float value) throws OSStatusException {
        AudioSession.setProperty(id, new FloatPtr(value));
    }

    @Deprecated
    public static void setProperty(AudioSessionProperty id, double value) throws OSStatusException {
        AudioSession.setProperty(id, new DoublePtr(value));
    }

    @Deprecated
    public static int getPropertySize(AudioSessionProperty id) throws OSStatusException {
        IntPtr ptr = new IntPtr();
        OSStatus status = AudioSession.getPropertySize0(id, ptr);
        OSStatusException.throwIfNecessary(status);
        return ptr.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void addPropertyListener(AudioSessionProperty id, PropertyListener listener) throws OSStatusException {
        long cid = callbackId.getAndIncrement();
        OSStatus status = AudioSession.addPropertyListener0(id, new FunctionPtr(cbPropertyChanged), cid);
        if (OSStatusException.throwIfNecessary(status)) {
            LongMap<PropertyListener> longMap = propertyListeners;
            synchronized (longMap) {
                propertyListeners.put(cid, (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void removePropertyListener(AudioSessionProperty id, PropertyListener listener) throws OSStatusException {
        LongMap<PropertyListener> longMap = propertyListeners;
        synchronized (longMap) {
            for (LongMap.Entry entry : propertyListeners.entries()) {
                if (entry.value != listener) continue;
                OSStatus status = AudioSession.removePropertyListener0(id, new FunctionPtr(cbPropertyChanged), entry.key);
                OSStatusException.throwIfNecessary(status);
            }
        }
    }

    @Deprecated
    @Bridge(symbol="AudioSessionInitialize", optional=true)
    protected static native OSStatus initialize0(NSRunLoop var0, String var1, FunctionPtr var2, @Pointer long var3);

    @Deprecated
    @Bridge(symbol="AudioSessionSetActive", optional=true)
    protected static native OSStatus setActive0(boolean var0);

    @Deprecated
    @Bridge(symbol="AudioSessionSetActiveWithFlags", optional=true)
    protected static native OSStatus setActive0(boolean var0, AudioSessionActivationFlags var1);

    @Deprecated
    @Bridge(symbol="AudioSessionGetProperty", optional=true)
    protected static native OSStatus getProperty0(AudioSessionProperty var0, IntPtr var1, VoidPtr var2);

    @Deprecated
    @Bridge(symbol="AudioSessionSetProperty", optional=true)
    protected static native OSStatus setProperty0(AudioSessionProperty var0, int var1, VoidPtr var2);

    @Deprecated
    @Bridge(symbol="AudioSessionGetPropertySize", optional=true)
    protected static native OSStatus getPropertySize0(AudioSessionProperty var0, IntPtr var1);

    @Deprecated
    @Bridge(symbol="AudioSessionAddPropertyListener", optional=true)
    protected static native OSStatus addPropertyListener0(AudioSessionProperty var0, FunctionPtr var1, @Pointer long var2);

    @Deprecated
    @Bridge(symbol="AudioSessionRemovePropertyListenerWithUserData", optional=true)
    protected static native OSStatus removePropertyListener0(AudioSessionProperty var0, FunctionPtr var1, @Pointer long var2);

    static {
        interruptionListeners = new LongMap();
        try {
            cbPropertyChanged = AudioSession.class.getDeclaredMethod("cbPropertyChanged", Long.TYPE, AudioSessionProperty.class, Integer.TYPE, VoidPtr.class);
            cbInterruption = AudioSession.class.getDeclaredMethod("cbInterruption", Long.TYPE, AudioSessionInterruptionState.class);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(AudioSession.class);
    }

    public static interface InterruptionListener {
        public void onInterrupt(AudioSessionInterruptionState var1);
    }

    public static interface PropertyListener {
        public void onChange(AudioSessionProperty var1, int var2, VoidPtr var3);
    }
}

