/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import org.robovm.apple.addressbook.ABPersonSocialProfileService;
import org.robovm.apple.addressbook.ABPropertyLabel;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="AddressBook")
public class ABPersonSocialProfile
extends CocoaUtility {
    private CFDictionary data;
    private CFString label;

    public ABPersonSocialProfile(String label) {
        this.data = CFMutableDictionary.create();
        this.label = new CFString(label);
    }

    public ABPersonSocialProfile(ABPropertyLabel label) {
        this.data = CFMutableDictionary.create();
        this.label = label.value();
    }

    protected ABPersonSocialProfile(CFDictionary data, CFString label) {
        this.data = data;
        this.label = label;
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public String getLabel() {
        return this.label.toString();
    }

    protected CFString getLabel0() {
        return this.label;
    }

    public String getURL() {
        if (this.data.containsKey(ABPersonSocialProfile.URLKey())) {
            CFString val = this.data.get(ABPersonSocialProfile.URLKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public ABPersonSocialProfile setURL(String url) {
        this.data.put(ABPersonSocialProfile.URLKey(), new CFString(url));
        return this;
    }

    public ABPersonSocialProfileService getService() {
        if (this.data.containsKey(ABPersonSocialProfile.ServiceKey())) {
            CFString val = this.data.get(ABPersonSocialProfile.ServiceKey(), CFString.class);
            return ABPersonSocialProfileService.valueOf(val);
        }
        return null;
    }

    public ABPersonSocialProfile setService(ABPersonSocialProfileService service) {
        this.data.put(ABPersonSocialProfile.ServiceKey(), service.value());
        return this;
    }

    public String getUsername() {
        if (this.data.containsKey(ABPersonSocialProfile.UsernameKey())) {
            CFString val = this.data.get(ABPersonSocialProfile.UsernameKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public ABPersonSocialProfile setUsername(String username) {
        this.data.put(ABPersonSocialProfile.UsernameKey(), new CFString(username));
        return this;
    }

    public String getUserIdentifier() {
        if (this.data.containsKey(ABPersonSocialProfile.UserIdentifierKey())) {
            CFString val = this.data.get(ABPersonSocialProfile.UserIdentifierKey(), CFString.class);
            return val.toString();
        }
        return null;
    }

    public ABPersonSocialProfile setUserIdentifier(String userIdentifier) {
        this.data.put(ABPersonSocialProfile.UserIdentifierKey(), new CFString(userIdentifier));
        return this;
    }

    @GlobalValue(symbol="kABPersonSocialProfileURLKey", optional=true)
    protected static native CFString URLKey();

    @GlobalValue(symbol="kABPersonSocialProfileServiceKey", optional=true)
    protected static native CFString ServiceKey();

    @GlobalValue(symbol="kABPersonSocialProfileUsernameKey", optional=true)
    protected static native CFString UsernameKey();

    @GlobalValue(symbol="kABPersonSocialProfileUserIdentifierKey", optional=true)
    protected static native CFString UserIdentifierKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(ABPersonSocialProfile.class);
    }
}

