/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableDictionary;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.foundation.CocoaUtility;
import org.robovm.apple.foundation.NSCalendarIdentifier;
import org.robovm.apple.foundation.NSNumber;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="AddressBook")
public class ABPersonAlternateBirthday
extends CocoaUtility {
    private CFDictionary data;

    public ABPersonAlternateBirthday() {
        this.data = CFMutableDictionary.create();
    }

    protected ABPersonAlternateBirthday(CFDictionary data) {
        this.data = data;
    }

    public CFDictionary getDictionary() {
        return this.data;
    }

    public NSCalendarIdentifier getCalendarIdentifier() {
        if (this.data.containsKey(ABPersonAlternateBirthday.CalendarIdentifierKey())) {
            NSString val = this.data.get(ABPersonAlternateBirthday.CalendarIdentifierKey(), NSString.class);
            return NSCalendarIdentifier.valueOf(val);
        }
        return null;
    }

    public ABPersonAlternateBirthday setCalendarIdentifier(NSCalendarIdentifier identifier) {
        this.data.put(ABPersonAlternateBirthday.CalendarIdentifierKey(), (NativeObject)identifier.value());
        return this;
    }

    public long getEra() {
        if (this.data.containsKey(ABPersonAlternateBirthday.EraKey())) {
            NSNumber val = this.data.get(ABPersonAlternateBirthday.EraKey(), NSNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public ABPersonAlternateBirthday setEra(long era) {
        this.data.put(ABPersonAlternateBirthday.EraKey(), (NativeObject)NSNumber.valueOf(era));
        return this;
    }

    public long getYear() {
        if (this.data.containsKey(ABPersonAlternateBirthday.YearKey())) {
            NSNumber val = this.data.get(ABPersonAlternateBirthday.YearKey(), NSNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public ABPersonAlternateBirthday setYear(long year) {
        this.data.put(ABPersonAlternateBirthday.YearKey(), (NativeObject)NSNumber.valueOf(year));
        return this;
    }

    public long getMonth() {
        if (this.data.containsKey(ABPersonAlternateBirthday.MonthKey())) {
            NSNumber val = this.data.get(ABPersonAlternateBirthday.MonthKey(), NSNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public ABPersonAlternateBirthday setMonth(long month) {
        this.data.put(ABPersonAlternateBirthday.MonthKey(), (NativeObject)NSNumber.valueOf(month));
        return this;
    }

    public boolean isLeapMonth() {
        if (this.data.containsKey(ABPersonAlternateBirthday.IsLeapMonthKey())) {
            CFNumber val = this.data.get(ABPersonAlternateBirthday.IsLeapMonthKey(), CFNumber.class);
            return val.charValue() != '\u0000';
        }
        return false;
    }

    public ABPersonAlternateBirthday setLeapMonth(boolean leapMonth) {
        this.data.put(ABPersonAlternateBirthday.IsLeapMonthKey(), CFNumber.valueOf(leapMonth ? 1 : 0));
        return this;
    }

    public long getDay() {
        if (this.data.containsKey(ABPersonAlternateBirthday.DayKey())) {
            NSNumber val = this.data.get(ABPersonAlternateBirthday.DayKey(), NSNumber.class);
            return val.longValue();
        }
        return 0L;
    }

    public ABPersonAlternateBirthday setDay(long day) {
        this.data.put(ABPersonAlternateBirthday.DayKey(), (NativeObject)NSNumber.valueOf(day));
        return this;
    }

    @GlobalValue(symbol="kABPersonAlternateBirthdayCalendarIdentifierKey", optional=true)
    protected static native CFString CalendarIdentifierKey();

    @GlobalValue(symbol="kABPersonAlternateBirthdayEraKey", optional=true)
    protected static native CFString EraKey();

    @GlobalValue(symbol="kABPersonAlternateBirthdayYearKey", optional=true)
    protected static native CFString YearKey();

    @GlobalValue(symbol="kABPersonAlternateBirthdayMonthKey", optional=true)
    protected static native CFString MonthKey();

    @GlobalValue(symbol="kABPersonAlternateBirthdayIsLeapMonthKey", optional=true)
    protected static native CFString IsLeapMonthKey();

    @GlobalValue(symbol="kABPersonAlternateBirthdayDayKey", optional=true)
    protected static native CFString DayKey();

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    static {
        Bro.bind(ABPersonAlternateBirthday.class);
    }
}

