/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import java.util.ArrayList;
import java.util.List;
import org.robovm.apple.addressbook.ABMultiValue;
import org.robovm.apple.addressbook.ABMutableMultiValue;
import org.robovm.apple.addressbook.ABPersonAddress;
import org.robovm.apple.addressbook.ABPersonAlternateBirthday;
import org.robovm.apple.addressbook.ABPersonCompositeNameFormat;
import org.robovm.apple.addressbook.ABPersonDate;
import org.robovm.apple.addressbook.ABPersonEmailAddress;
import org.robovm.apple.addressbook.ABPersonImageFormat;
import org.robovm.apple.addressbook.ABPersonInstantMessageAccount;
import org.robovm.apple.addressbook.ABPersonKind;
import org.robovm.apple.addressbook.ABPersonPhoneNumber;
import org.robovm.apple.addressbook.ABPersonProperty;
import org.robovm.apple.addressbook.ABPersonRelatedName;
import org.robovm.apple.addressbook.ABPersonSocialProfile;
import org.robovm.apple.addressbook.ABPersonSortOrdering;
import org.robovm.apple.addressbook.ABPersonURL;
import org.robovm.apple.addressbook.ABPropertyType;
import org.robovm.apple.addressbook.ABRecord;
import org.robovm.apple.addressbook.ABSource;
import org.robovm.apple.corefoundation.CFArray;
import org.robovm.apple.corefoundation.CFComparisonResult;
import org.robovm.apple.corefoundation.CFDate;
import org.robovm.apple.corefoundation.CFDictionary;
import org.robovm.apple.corefoundation.CFMutableArray;
import org.robovm.apple.corefoundation.CFNumber;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDate;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSObject;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.NativeObject;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.MarshalsPointer;

@Library(value="AddressBook")
public class ABPerson
extends ABRecord {
    public String getFirstName() {
        CFString val = this.getValue(ABPersonProperty.FirstName, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setFirstName(String firstName) throws NSErrorException {
        if (firstName == null) {
            this.setValue(ABPersonProperty.FirstName, null);
        } else {
            this.setValue(ABPersonProperty.FirstName, new CFString(firstName));
        }
        return this;
    }

    public String getLastName() {
        CFString val = this.getValue(ABPersonProperty.LastName, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setLastName(String lastName) throws NSErrorException {
        if (lastName == null) {
            this.setValue(ABPersonProperty.LastName, null);
        } else {
            this.setValue(ABPersonProperty.LastName, new CFString(lastName));
        }
        return this;
    }

    public String getMiddleName() {
        CFString val = this.getValue(ABPersonProperty.MiddleName, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setMiddleName(String middleName) throws NSErrorException {
        if (middleName == null) {
            this.setValue(ABPersonProperty.MiddleName, null);
        } else {
            this.setValue(ABPersonProperty.MiddleName, new CFString(middleName));
        }
        return this;
    }

    public String getPrefix() {
        CFString val = this.getValue(ABPersonProperty.Prefix, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setPrefix(String prefix) throws NSErrorException {
        if (prefix == null) {
            this.setValue(ABPersonProperty.Prefix, null);
        } else {
            this.setValue(ABPersonProperty.Prefix, new CFString(prefix));
        }
        return this;
    }

    public String getSuffix() {
        CFString val = this.getValue(ABPersonProperty.Suffix, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setSuffix(String suffix) throws NSErrorException {
        if (suffix == null) {
            this.setValue(ABPersonProperty.Suffix, null);
        } else {
            this.setValue(ABPersonProperty.Suffix, new CFString(suffix));
        }
        return this;
    }

    public String getNickname() {
        CFString val = this.getValue(ABPersonProperty.Nickname, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setNickname(String nickname) throws NSErrorException {
        if (nickname == null) {
            this.setValue(ABPersonProperty.Nickname, null);
        } else {
            this.setValue(ABPersonProperty.Nickname, new CFString(nickname));
        }
        return this;
    }

    public String getFirstNamePhonetic() {
        CFString val = this.getValue(ABPersonProperty.FirstNamePhonetic, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setFirstNamePhonetic(String firstNamePhonetic) throws NSErrorException {
        if (firstNamePhonetic == null) {
            this.setValue(ABPersonProperty.FirstNamePhonetic, null);
        } else {
            this.setValue(ABPersonProperty.FirstNamePhonetic, new CFString(firstNamePhonetic));
        }
        return this;
    }

    public String getLastNamePhonetic() {
        CFString val = this.getValue(ABPersonProperty.LastNamePhonetic, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setLastNamePhonetic(String lastNamePhonetic) throws NSErrorException {
        if (lastNamePhonetic == null) {
            this.setValue(ABPersonProperty.LastNamePhonetic, null);
        } else {
            this.setValue(ABPersonProperty.LastNamePhonetic, new CFString(lastNamePhonetic));
        }
        return this;
    }

    public String getMiddleNamePhonetic() {
        CFString val = this.getValue(ABPersonProperty.MiddleNamePhonetic, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setMiddleNamePhonetic(String middleNamePhonetic) throws NSErrorException {
        if (middleNamePhonetic == null) {
            this.setValue(ABPersonProperty.MiddleNamePhonetic, null);
        } else {
            this.setValue(ABPersonProperty.MiddleNamePhonetic, new CFString(middleNamePhonetic));
        }
        return this;
    }

    public String getOrganization() {
        CFString val = this.getValue(ABPersonProperty.Organization, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setOrganization(String organization) throws NSErrorException {
        if (organization == null) {
            this.setValue(ABPersonProperty.Organization, null);
        } else {
            this.setValue(ABPersonProperty.Organization, new CFString(organization));
        }
        return this;
    }

    public String getJobTitle() {
        CFString val = this.getValue(ABPersonProperty.JobTitle, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setJobTitle(String jobTitle) throws NSErrorException {
        if (jobTitle == null) {
            this.setValue(ABPersonProperty.JobTitle, null);
        } else {
            this.setValue(ABPersonProperty.JobTitle, new CFString(jobTitle));
        }
        return this;
    }

    public String getDepartment() {
        CFString val = this.getValue(ABPersonProperty.Department, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setDepartment(String department) throws NSErrorException {
        if (department == null) {
            this.setValue(ABPersonProperty.Department, null);
        } else {
            this.setValue(ABPersonProperty.Department, new CFString(department));
        }
        return this;
    }

    public List<ABPersonEmailAddress> getEmailAddresses() {
        ABMultiValue val = this.getValue(ABPersonProperty.Email, ABMultiValue.class);
        ArrayList<ABPersonEmailAddress> list = new ArrayList<ABPersonEmailAddress>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFString address = (CFString)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonEmailAddress(address, label));
            ++i;
        }
        return list;
    }

    public ABPerson setEmailAddresses(List<ABPersonEmailAddress> emailAddresses) throws NSErrorException {
        if (emailAddresses == null) {
            this.setValue(ABPersonProperty.Email, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiString);
            for (ABPersonEmailAddress address : emailAddresses) {
                val.addValueAndLabel(address.getAddress0(), address.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.Email, val);
        }
        return this;
    }

    public int addEmailAddress(ABPersonEmailAddress emailAddress) throws NSErrorException {
        if (emailAddress == null) {
            throw new NullPointerException("emailAddress");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.Email, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiString);
        int result = mutable.addValueAndLabel((CFType)emailAddress.getAddress0(), emailAddress.getLabel0());
        this.setValue(ABPersonProperty.Email, mutable);
        return result;
    }

    public boolean removeEmailAddress(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.Email, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.Email, mutable);
            return result;
        }
        return false;
    }

    public NSDate getBirthday() {
        NSDate val = this.getValue(ABPersonProperty.Birthday, NSDate.class);
        return val;
    }

    public ABPerson setBirthday(NSDate birthday) throws NSErrorException {
        if (birthday == null) {
            this.setValue(ABPersonProperty.Birthday, null);
        } else {
            this.setValue(ABPersonProperty.Birthday, (CFType)birthday.as(CFDate.class));
        }
        return this;
    }

    public String getNote() {
        CFString val = this.getValue(ABPersonProperty.Note, CFString.class);
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    public ABPerson setNote(String note) throws NSErrorException {
        if (note == null) {
            this.setValue(ABPersonProperty.Note, null);
        } else {
            this.setValue(ABPersonProperty.Note, new CFString(note));
        }
        return this;
    }

    public NSDate getCreationDate() {
        NSDate val = this.getValue(ABPersonProperty.CreationDate, NSDate.class);
        return val;
    }

    public ABPerson setCreationDate(NSDate creationDate) throws NSErrorException {
        if (creationDate == null) {
            this.setValue(ABPersonProperty.CreationDate, null);
        } else {
            this.setValue(ABPersonProperty.CreationDate, (CFType)creationDate.as(CFDate.class));
        }
        return this;
    }

    public NSDate getModificationDate() {
        NSDate val = this.getValue(ABPersonProperty.ModificationDate, NSDate.class);
        return val;
    }

    public ABPerson setModificationDate(NSDate modificationDate) throws NSErrorException {
        if (modificationDate == null) {
            this.setValue(ABPersonProperty.ModificationDate, null);
        } else {
            this.setValue(ABPersonProperty.ModificationDate, (CFType)modificationDate.as(CFDate.class));
        }
        return this;
    }

    public List<ABPersonAddress> getAddresses() {
        ABMultiValue val = this.getValue(ABPersonProperty.Address, ABMultiValue.class);
        ArrayList<ABPersonAddress> list = new ArrayList<ABPersonAddress>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFDictionary address = (CFDictionary)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonAddress(address, label));
            ++i;
        }
        return list;
    }

    public ABPerson setAddresses(List<ABPersonAddress> addresses) throws NSErrorException {
        if (addresses == null) {
            this.setValue(ABPersonProperty.Address, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
            for (ABPersonAddress address : addresses) {
                val.addValueAndLabel(address.getDictionary(), address.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.Address, val);
        }
        return this;
    }

    public int addAddress(ABPersonAddress address) throws NSErrorException {
        if (address == null) {
            throw new NullPointerException("address");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.Address, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
        int result = mutable.addValueAndLabel((CFType)address.getDictionary(), address.getLabel0());
        this.setValue(ABPersonProperty.Address, mutable);
        return result;
    }

    public boolean removeAddress(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.Address, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.Address, mutable);
            return result;
        }
        return false;
    }

    public List<ABPersonDate> getDates() {
        ABMultiValue val = this.getValue(ABPersonProperty.Date, ABMultiValue.class);
        ArrayList<ABPersonDate> list = new ArrayList<ABPersonDate>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            NSDate date = (NSDate)val.getValue(i).as(NSDate.class);
            CFString label = val.getLabel(i);
            list.add(new ABPersonDate(date, label));
            ++i;
        }
        return list;
    }

    public ABPerson setDates(List<ABPersonDate> dates) throws NSErrorException {
        if (dates == null) {
            this.setValue(ABPersonProperty.Date, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiDateTime);
            for (ABPersonDate date : dates) {
                val.addValueAndLabel((CFType)date.getDate().as(CFDate.class), date.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.Date, val);
        }
        return this;
    }

    public ABPersonKind getKind() {
        CFNumber val = this.getValue(ABPersonProperty.Kind, CFNumber.class);
        return ABPersonKind.valueOf(val);
    }

    public ABPerson setKind(ABPersonKind kind) throws NSErrorException {
        if (kind == null) {
            this.setValue(ABPersonProperty.Kind, null);
        } else {
            this.setValue(ABPersonProperty.Kind, kind.value());
        }
        return this;
    }

    public List<ABPersonPhoneNumber> getPhoneNumbers() {
        ABMultiValue val = this.getValue(ABPersonProperty.Phone, ABMultiValue.class);
        ArrayList<ABPersonPhoneNumber> list = new ArrayList<ABPersonPhoneNumber>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFString number = (CFString)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonPhoneNumber(number, label));
            ++i;
        }
        return list;
    }

    public ABPerson setPhoneNumbers(List<ABPersonPhoneNumber> phoneNumbers) throws NSErrorException {
        if (phoneNumbers == null) {
            this.setValue(ABPersonProperty.Phone, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiString);
            for (ABPersonPhoneNumber number : phoneNumbers) {
                val.addValueAndLabel(number.getNumber0(), number.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.Phone, val);
        }
        return this;
    }

    public int addPhoneNumber(ABPersonPhoneNumber phoneNumber) throws NSErrorException {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.Phone, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiString);
        int result = mutable.addValueAndLabel((CFType)phoneNumber.getNumber0(), phoneNumber.getLabel0());
        this.setValue(ABPersonProperty.Phone, mutable);
        return result;
    }

    public boolean removePhoneNumber(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.Phone, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.Phone, mutable);
            return result;
        }
        return false;
    }

    public List<ABPersonInstantMessageAccount> getInstantMessageAccounts() {
        ABMultiValue val = this.getValue(ABPersonProperty.InstantMessage, ABMultiValue.class);
        ArrayList<ABPersonInstantMessageAccount> list = new ArrayList<ABPersonInstantMessageAccount>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFDictionary dict = (CFDictionary)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonInstantMessageAccount(dict, label));
            ++i;
        }
        return list;
    }

    public ABPerson setInstantMessageAccounts(List<ABPersonInstantMessageAccount> instantMessageAccounts) throws NSErrorException {
        if (instantMessageAccounts == null) {
            this.setValue(ABPersonProperty.InstantMessage, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
            for (ABPersonInstantMessageAccount account : instantMessageAccounts) {
                val.addValueAndLabel(account.getDictionary(), account.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.InstantMessage, val);
        }
        return this;
    }

    public int addInstantMessageAccount(ABPersonInstantMessageAccount instantMessageAccount) throws NSErrorException {
        if (instantMessageAccount == null) {
            throw new NullPointerException("instantMessageAccount");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.InstantMessage, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
        int result = mutable.addValueAndLabel((CFType)instantMessageAccount.getDictionary(), instantMessageAccount.getLabel0());
        this.setValue(ABPersonProperty.InstantMessage, mutable);
        return result;
    }

    public boolean removeInstantMessageAccount(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.InstantMessage, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.InstantMessage, mutable);
            return result;
        }
        return false;
    }

    public List<ABPersonSocialProfile> getSocialProfiles() {
        ABMultiValue val = this.getValue(ABPersonProperty.SocialProfile, ABMultiValue.class);
        ArrayList<ABPersonSocialProfile> list = new ArrayList<ABPersonSocialProfile>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFDictionary dict = (CFDictionary)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonSocialProfile(dict, label));
            ++i;
        }
        return list;
    }

    public ABPerson setSocialProfiles(List<ABPersonSocialProfile> socialProfiles) throws NSErrorException {
        if (socialProfiles == null) {
            this.setValue(ABPersonProperty.SocialProfile, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
            for (ABPersonSocialProfile account : socialProfiles) {
                val.addValueAndLabel(account.getDictionary(), account.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.SocialProfile, val);
        }
        return this;
    }

    public int addSocialProfile(ABPersonSocialProfile socialProfile) throws NSErrorException {
        if (socialProfile == null) {
            throw new NullPointerException("socialProfile");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.SocialProfile, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiDictionary);
        int result = mutable.addValueAndLabel((CFType)socialProfile.getDictionary(), socialProfile.getLabel0());
        this.setValue(ABPersonProperty.SocialProfile, mutable);
        return result;
    }

    public boolean removeSocialProfile(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.SocialProfile, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.SocialProfile, mutable);
            return result;
        }
        return false;
    }

    public List<ABPersonURL> getURLs() {
        ABMultiValue val = this.getValue(ABPersonProperty.URL, ABMultiValue.class);
        ArrayList<ABPersonURL> list = new ArrayList<ABPersonURL>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFString url = (CFString)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonURL(url, label));
            ++i;
        }
        return list;
    }

    public ABPerson setURLs(List<ABPersonURL> urls) throws NSErrorException {
        if (urls == null) {
            this.setValue(ABPersonProperty.URL, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiString);
            for (ABPersonURL url : urls) {
                val.addValueAndLabel(url.getURL0(), url.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.URL, val);
        }
        return this;
    }

    public int addURL(ABPersonURL url) throws NSErrorException {
        if (url == null) {
            throw new NullPointerException("url");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.URL, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiString);
        int result = mutable.addValueAndLabel((CFType)url.getURL0(), url.getLabel0());
        this.setValue(ABPersonProperty.URL, mutable);
        return result;
    }

    public boolean removeURL(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.URL, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.URL, mutable);
            return result;
        }
        return false;
    }

    public List<ABPersonRelatedName> getRelatedNames() {
        ABMultiValue val = this.getValue(ABPersonProperty.RelatedNames, ABMultiValue.class);
        ArrayList<ABPersonRelatedName> list = new ArrayList<ABPersonRelatedName>();
        if (val == null) {
            return list;
        }
        long size = val.getCount();
        int i = 0;
        while ((long)i < size) {
            CFString name = (CFString)val.getValue(i);
            CFString label = val.getLabel(i);
            list.add(new ABPersonRelatedName(name, label));
            ++i;
        }
        return list;
    }

    public ABPerson setRelatedNames(List<ABPersonRelatedName> relatedNames) throws NSErrorException {
        if (relatedNames == null) {
            this.setValue(ABPersonProperty.RelatedNames, null);
        } else {
            ABMutableMultiValue val = ABMutableMultiValue.create(ABPropertyType.MultiString);
            for (ABPersonRelatedName relatedName : relatedNames) {
                val.addValueAndLabel(relatedName.getName0(), relatedName.getLabel0(), null);
            }
            this.setValue(ABPersonProperty.RelatedNames, val);
        }
        return this;
    }

    public int addRelatedName(ABPersonRelatedName relatedName) throws NSErrorException {
        if (relatedName == null) {
            throw new NullPointerException("relatedName");
        }
        ABMultiValue val = this.getValue(ABPersonProperty.RelatedNames, ABMultiValue.class);
        ABMutableMultiValue mutable = val != null ? ABMutableMultiValue.create(val) : ABMutableMultiValue.create(ABPropertyType.MultiString);
        int result = mutable.addValueAndLabel((CFType)relatedName.getName0(), relatedName.getLabel0());
        this.setValue(ABPersonProperty.RelatedNames, mutable);
        return result;
    }

    public boolean removeRelatedName(int id) throws NSErrorException {
        ABMultiValue val = this.getValue(ABPersonProperty.RelatedNames, ABMultiValue.class);
        if (val != null) {
            ABMutableMultiValue mutable = ABMutableMultiValue.create(val);
            boolean result = mutable.removeValueAndLabel(mutable.indexOf(id));
            this.setValue(ABPersonProperty.RelatedNames, mutable);
            return result;
        }
        return false;
    }

    public ABPersonAlternateBirthday getAlternateBirthday() {
        CFDictionary val = this.getValue(ABPersonProperty.AlternateBirthday, CFDictionary.class);
        if (val != null) {
            return new ABPersonAlternateBirthday(val);
        }
        return null;
    }

    public ABPerson setAlternateBirthday(ABPersonAlternateBirthday alternateBirthday) throws NSErrorException {
        if (alternateBirthday == null) {
            this.setValue(ABPersonProperty.AlternateBirthday, null);
        } else {
            this.setValue(ABPersonProperty.AlternateBirthday, alternateBirthday.getDictionary());
        }
        return this;
    }

    @Bridge(symbol="ABPersonCreate", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public static native ABPerson create();

    @Bridge(symbol="ABPersonCreateInSource", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public static native ABPerson create(ABSource var0);

    @Bridge(symbol="ABPersonCopySource", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public native ABSource getSource();

    @Bridge(symbol="ABPersonCopyArrayOfAllLinkedPeople", optional=true)
    @Marshaler(value=AsListMarshaler.class)
    public native List<ABPerson> getAllLinkedPeople();

    @Bridge(symbol="ABPersonGetSortOrdering", optional=true)
    public static native ABPersonSortOrdering getSortOrdering();

    @Deprecated
    @Bridge(symbol="ABPersonGetCompositeNameFormat", optional=true)
    public static native ABPersonCompositeNameFormat getConstantCompositeNameFormat();

    @Bridge(symbol="ABPersonGetCompositeNameFormatForRecord", optional=true)
    public native ABPersonCompositeNameFormat getCompositeNameFormat();

    @Bridge(symbol="ABPersonCopyCompositeNameDelimiterForRecord", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public native String getCompositeNameDelimiter();

    public boolean setImageData(NSData imageData) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.setImageData(imageData, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABPersonSetImageData", optional=true)
    private native boolean setImageData(NSData var1, NSError.NSErrorPtr var2);

    @Bridge(symbol="ABPersonCopyImageData", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getImageData();

    @Bridge(symbol="ABPersonCopyImageDataWithFormat", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public native NSData getImageData(ABPersonImageFormat var1);

    @Bridge(symbol="ABPersonHasImageData", optional=true)
    public native boolean hasImageData();

    public boolean removeImageData() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeImageData(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABPersonRemoveImageData", optional=true)
    private native boolean removeImageData(NSError.NSErrorPtr var1);

    @Bridge(symbol="ABPersonComparePeopleByName", optional=true)
    public native CFComparisonResult compareTo(ABRecord var1, ABPersonSortOrdering var2);

    @Bridge(symbol="ABPersonCreatePeopleInSourceWithVCardRepresentation", optional=true)
    @Marshaler(value=AsListMarshaler.class)
    public static native List<ABPerson> createPeopleWithVCardRepresentation(ABSource var0, NSData var1);

    @Bridge(symbol="ABPersonCreateVCardRepresentationWithPeople", optional=true)
    @Marshaler(value=NSObject.NoRetainMarshaler.class)
    public static native NSData createVCardRepresentationWithPeople(@Marshaler(value=AsListMarshaler.class) List<ABPerson> var0);

    static {
        Bro.bind(ABPerson.class);
    }

    public static class AsListMarshaler {
        @MarshalsPointer
        public static List<ABPerson> toObject(Class<? extends CFType> cls, long handle, long flags) {
            CFArray o = (CFArray)CFType.Marshaler.toObject(CFArray.class, handle, flags);
            if (o == null) {
                return null;
            }
            ArrayList<ABPerson> list = new ArrayList<ABPerson>();
            long n = o.size();
            for (long i = 0L; i < n; ++i) {
                ABRecord record = o.get(i, ABRecord.class);
                list.add((ABPerson)NativeObject.Marshaler.toObject(ABPerson.class, (long)record.getHandle(), (long)flags));
            }
            return list;
        }

        @MarshalsPointer
        public static long toNative(List<ABPerson> l, long flags) {
            if (l == null) {
                return 0L;
            }
            CFMutableArray array = CFMutableArray.create();
            for (ABPerson i : l) {
                ((CFArray)array).add(i);
            }
            return CFType.Marshaler.toNative(array, flags);
        }
    }
}

