/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.addressbook;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.robovm.apple.addressbook.ABAuthorizationStatus;
import org.robovm.apple.addressbook.ABGroup;
import org.robovm.apple.addressbook.ABPerson;
import org.robovm.apple.addressbook.ABPersonSortOrdering;
import org.robovm.apple.addressbook.ABPropertyLabel;
import org.robovm.apple.addressbook.ABRecord;
import org.robovm.apple.addressbook.ABSource;
import org.robovm.apple.corefoundation.CFString;
import org.robovm.apple.corefoundation.CFType;
import org.robovm.apple.foundation.NSDictionary;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSErrorException;
import org.robovm.apple.foundation.NSString;
import org.robovm.objc.LongMap;
import org.robovm.objc.annotation.Block;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.Bridge;
import org.robovm.rt.bro.annotation.Callback;
import org.robovm.rt.bro.annotation.Library;
import org.robovm.rt.bro.annotation.MachineSizedSInt;
import org.robovm.rt.bro.annotation.Marshaler;
import org.robovm.rt.bro.annotation.Pointer;
import org.robovm.rt.bro.ptr.FunctionPtr;

@Library(value="AddressBook")
public class ABAddressBook
extends CFType {
    private static final AtomicLong changeCallbackId = new AtomicLong();
    private static final LongMap<ExternalChangeCallback> externalChangeCallbacks = new LongMap();
    private static final Method cbExternalChange;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callback
    private static void cbExternalChange(ABAddressBook addressBook, NSDictionary<?, ?> info, @Pointer long refcon) {
        ExternalChangeCallback callback = null;
        LongMap<ExternalChangeCallback> longMap = externalChangeCallbacks;
        synchronized (longMap) {
            callback = (ExternalChangeCallback)externalChangeCallbacks.get(refcon);
        }
        callback.externalChange(addressBook, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExternalChangeCallback(ExternalChangeCallback callback) {
        long refconId = changeCallbackId.getAndIncrement();
        this.registerExternalChangeCallback(new FunctionPtr(cbExternalChange), refconId);
        LongMap<ExternalChangeCallback> longMap = externalChangeCallbacks;
        synchronized (longMap) {
            externalChangeCallbacks.put(refconId, (Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterExternalChangeCallback(ExternalChangeCallback callback) {
        long refconId = 0L;
        LongMap<ExternalChangeCallback> longMap = externalChangeCallbacks;
        synchronized (longMap) {
            for (LongMap.Entry entry : externalChangeCallbacks.entries()) {
                if (entry.value != callback) continue;
                refconId = entry.key;
                externalChangeCallbacks.remove(refconId);
                break;
            }
        }
        this.unregisterExternalChangeCallback(new FunctionPtr(cbExternalChange), refconId);
    }

    public static String getLocalizedLabel(ABPropertyLabel label) {
        return ABAddressBook.getLocalizedLabel(label.value().toString());
    }

    @Bridge(symbol="ABAddressBookGetAuthorizationStatus", optional=true)
    public static native ABAuthorizationStatus getAuthorizationStatus();

    public static ABAddressBook create(NSDictionary<NSString, ?> options) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        ABAddressBook result = ABAddressBook.create(options, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABAddressBookCreateWithOptions", optional=true)
    @Marshaler(value=CFType.NoRetainMarshaler.class)
    private static native ABAddressBook create(NSDictionary<NSString, ?> var0, NSError.NSErrorPtr var1);

    @Deprecated
    @Bridge(symbol="ABAddressBookCreate", optional=true)
    public static native ABAddressBook create();

    @Bridge(symbol="ABAddressBookRequestAccessWithCompletion", optional=true)
    public native void requestAccess(@Block RequestAccessCompletionHandler var1);

    public boolean save() throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.save(ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABAddressBookSave", optional=true)
    private native boolean save(NSError.NSErrorPtr var1);

    @Bridge(symbol="ABAddressBookHasUnsavedChanges", optional=true)
    public native boolean hasUnsavedChanges();

    public boolean addRecord(ABRecord record) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.addRecord(record, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABAddressBookAddRecord", optional=true)
    private native boolean addRecord(ABRecord var1, NSError.NSErrorPtr var2);

    public boolean removeRecord(ABRecord record) throws NSErrorException {
        NSError.NSErrorPtr ptr = new NSError.NSErrorPtr();
        boolean result = this.removeRecord(record, ptr);
        if (ptr.get() != null) {
            throw new NSErrorException((NSError)ptr.get());
        }
        return result;
    }

    @Bridge(symbol="ABAddressBookRemoveRecord", optional=true)
    private native boolean removeRecord(ABRecord var1, NSError.NSErrorPtr var2);

    @Bridge(symbol="ABAddressBookCopyLocalizedLabel", optional=true)
    @Marshaler(value=CFString.AsStringNoRetainMarshaler.class)
    public static native String getLocalizedLabel(String var0);

    @Bridge(symbol="ABAddressBookRegisterExternalChangeCallback", optional=true)
    protected native void registerExternalChangeCallback(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="ABAddressBookUnregisterExternalChangeCallback", optional=true)
    protected native void unregisterExternalChangeCallback(FunctionPtr var1, @Pointer long var2);

    @Bridge(symbol="ABAddressBookRevert", optional=true)
    public native void revert();

    @Bridge(symbol="ABAddressBookCopyDefaultSource", optional=true)
    @Marshaler(value=ABRecord.NoRetainMarshaler.class)
    public native ABSource getDefaultSource();

    @Bridge(symbol="ABAddressBookGetSourceWithRecordID", optional=true)
    public native ABSource getSource(int var1);

    @Bridge(symbol="ABAddressBookCopyArrayOfAllSources", optional=true)
    @Marshaler(value=ABSource.AsListMarshaler.class)
    public native List<ABSource> getAllSources();

    @Bridge(symbol="ABAddressBookGetPersonCount", optional=true)
    @MachineSizedSInt
    public native long getPersonCount();

    @Bridge(symbol="ABAddressBookGetPersonWithRecordID", optional=true)
    public native ABPerson getPerson(int var1);

    @Bridge(symbol="ABAddressBookCopyArrayOfAllPeople", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getAllPeople();

    @Bridge(symbol="ABAddressBookCopyArrayOfAllPeopleInSource", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getAllPeopleInSource(ABSource var1);

    @Bridge(symbol="ABAddressBookCopyArrayOfAllPeopleInSourceWithSortOrdering", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getAllPeopleInSource(ABSource var1, ABPersonSortOrdering var2);

    @Bridge(symbol="ABAddressBookCopyPeopleWithName", optional=true)
    @Marshaler(value=ABPerson.AsListMarshaler.class)
    public native List<ABPerson> getPeople(String var1);

    @Bridge(symbol="ABAddressBookGetGroupWithRecordID", optional=true)
    public native ABGroup getGroup(int var1);

    @Bridge(symbol="ABAddressBookGetGroupCount", optional=true)
    @MachineSizedSInt
    public native long getGroupCount();

    @Bridge(symbol="ABAddressBookCopyArrayOfAllGroups", optional=true)
    @Marshaler(value=ABGroup.AsListMarshaler.class)
    public native List<ABGroup> getAllGroups();

    @Bridge(symbol="ABAddressBookCopyArrayOfAllGroupsInSource", optional=true)
    @Marshaler(value=ABGroup.AsListMarshaler.class)
    public native List<ABGroup> getAllGroupsInSource(ABSource var1);

    static {
        try {
            cbExternalChange = ABAddressBook.class.getDeclaredMethod("cbExternalChange", ABAddressBook.class, NSDictionary.class, Long.TYPE);
        }
        catch (Throwable e) {
            throw new Error(e);
        }
        Bro.bind(ABAddressBook.class);
    }

    public static interface ExternalChangeCallback {
        public void externalChange(ABAddressBook var1, NSDictionary<?, ?> var2);
    }

    public static interface RequestAccessCompletionHandler {
        public void requestAccess(boolean var1, NSError var2);
    }
}

