/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.accounts;

import java.util.Collection;
import java.util.List;
import org.robovm.apple.accounts.ACAccountOptions;
import org.robovm.apple.accounts.ACFacebookAudience;
import org.robovm.apple.foundation.NSArray;
import org.robovm.apple.foundation.NSString;
import org.robovm.rt.bro.Bro;
import org.robovm.rt.bro.annotation.GlobalValue;
import org.robovm.rt.bro.annotation.Library;

@Library(value="Accounts")
public class ACFacebookOptions
extends ACAccountOptions {
    public String getAppId() {
        if (this.data.containsKey(ACFacebookOptions.AppIdKey())) {
            NSString val = (NSString)this.data.get(ACFacebookOptions.AppIdKey());
            return val.toString();
        }
        return null;
    }

    public void setAppId(String appId) {
        this.data.put(ACFacebookOptions.AppIdKey(), new NSString(appId));
    }

    public List<String> getPermissions() {
        if (this.data.containsKey(ACFacebookOptions.PermissionsKey())) {
            NSArray val = (NSArray)this.data.get(ACFacebookOptions.PermissionsKey());
            return val.asStringList();
        }
        return null;
    }

    public void setPermissions(Collection<String> permissions) {
        NSArray<NSString> p = NSArray.fromStrings(permissions);
        this.data.put(ACFacebookOptions.PermissionsKey(), p);
    }

    public void setPermissions(String ... permissions) {
        NSArray<NSString> p = NSArray.fromStrings(permissions);
        this.data.put(ACFacebookOptions.PermissionsKey(), p);
    }

    public ACFacebookAudience getAudience() {
        if (this.data.containsKey(ACFacebookOptions.AudienceKey())) {
            NSString val = (NSString)this.data.get(ACFacebookOptions.AudienceKey());
            return ACFacebookAudience.valueOf(val);
        }
        return null;
    }

    public void setAudience(ACFacebookAudience audience) {
        this.data.put(ACFacebookOptions.AudienceKey(), audience.value());
    }

    @GlobalValue(symbol="ACFacebookAppIdKey", optional=true)
    protected static native NSString AppIdKey();

    @GlobalValue(symbol="ACFacebookPermissionsKey", optional=true)
    protected static native NSString PermissionsKey();

    @GlobalValue(symbol="ACFacebookAudienceKey", optional=true)
    protected static native NSString AudienceKey();

    static {
        Bro.bind(ACFacebookOptions.class);
    }
}

