/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.apple.accounts;

import org.robovm.apple.accounts.ACError;
import org.robovm.apple.foundation.NSErrorCode;
import org.robovm.rt.bro.annotation.ForceLinkClass;

@ForceLinkClass(value=ACError.class)
public enum ACErrorCode implements NSErrorCode
{
    Unknown(1L),
    AccountMissingRequiredProperty(2L),
    AccountAuthenticationFailed(3L),
    AccountTypeInvalid(4L),
    AccountAlreadyExists(5L),
    AccountNotFound(6L),
    PermissionDenied(7L),
    AccessInfoInvalid(8L),
    ClientPermissionDenied(9L),
    AccessDeniedByProtectionPolicy(10L),
    CredentialNotFound(11L),
    FetchCredentialFailed(12L),
    StoreCredentialFailed(13L),
    RemoveCredentialFailed(14L),
    UpdatingNonexistentAccount(15L),
    InvalidClientBundleID(16L),
    DeniedByPlugin(17L),
    CoreDataSaveFailed(18L),
    FailedSerializingAccountInfo(19L),
    InvalidCommand(20L),
    MissingTransportMessageID(21L);

    private final long n;

    private ACErrorCode(long n2) {
        this.n = n2;
    }

    public long value() {
        return this.n;
    }

    public static ACErrorCode valueOf(long n) {
        for (ACErrorCode v : ACErrorCode.values()) {
            if (v.n != n) continue;
            return v;
        }
        throw new IllegalArgumentException("No constant with value " + n + " found in " + ACErrorCode.class.getName());
    }
}

