/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.util.Printer;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.AsmUtils;
import org.parboiled.transform.InstructionGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstructionGraphNode
extends BasicValue {
    private AbstractInsnNode instruction;
    private final BasicValue resultValue;
    private final List<InstructionGraphNode> predecessors = new ArrayList<InstructionGraphNode>();
    private boolean isActionRoot;
    private final boolean isVarInitRoot;
    private final boolean isCallOnContextAware;
    private final boolean isXLoad;
    private final boolean isXStore;
    private InstructionGroup group;

    public InstructionGraphNode(AbstractInsnNode abstractInsnNode, BasicValue basicValue) {
        super(null);
        this.instruction = abstractInsnNode;
        this.resultValue = basicValue;
        this.isActionRoot = AsmUtils.isActionRoot(abstractInsnNode);
        this.isVarInitRoot = AsmUtils.isVarRoot(abstractInsnNode);
        this.isCallOnContextAware = AsmUtils.isCallOnContextAware(abstractInsnNode);
        this.isXLoad = 21 <= abstractInsnNode.getOpcode() && abstractInsnNode.getOpcode() < 46;
        this.isXStore = 54 <= abstractInsnNode.getOpcode() && abstractInsnNode.getOpcode() < 79;
    }

    public int getSize() {
        return this.resultValue.getSize();
    }

    public AbstractInsnNode getInstruction() {
        return this.instruction;
    }

    public void setInstruction(AbstractInsnNode abstractInsnNode) {
        this.instruction = abstractInsnNode;
    }

    public BasicValue getResultValue() {
        return this.resultValue;
    }

    public List<InstructionGraphNode> getPredecessors() {
        return this.predecessors;
    }

    public InstructionGroup getGroup() {
        return this.group;
    }

    public void setGroup(InstructionGroup instructionGroup) {
        if (instructionGroup != this.group) {
            if (this.group != null) {
                this.group.getNodes().remove((Object)this);
            }
            this.group = instructionGroup;
            if (this.group != null) {
                this.group.getNodes().add(this);
            }
        }
    }

    public boolean isActionRoot() {
        return this.isActionRoot;
    }

    public void setIsActionRoot() {
        this.isActionRoot = true;
    }

    public boolean isVarInitRoot() {
        return this.isVarInitRoot;
    }

    public boolean isCallOnContextAware() {
        return this.isCallOnContextAware;
    }

    public boolean isXLoad() {
        return this.isXLoad;
    }

    public boolean isXStore() {
        return this.isXStore;
    }

    public void addPredecessors(Collection<BasicValue> collection) {
        Preconditions.checkArgNotNull(collection, (String)"preds");
        for (BasicValue basicValue : collection) {
            if (!(basicValue instanceof InstructionGraphNode)) continue;
            this.addPredecessor((InstructionGraphNode)basicValue);
        }
    }

    public void addPredecessor(InstructionGraphNode instructionGraphNode) {
        if (!this.predecessors.contains((Object)instructionGraphNode)) {
            this.predecessors.add(instructionGraphNode);
        }
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString() {
        return this.instruction.getOpcode() != -1 ? Printer.OPCODES[this.instruction.getOpcode()] : super.toString();
    }
}

