/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing.model;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.resource.ResourceManager;
import org.codehaus.plexus.resource.loader.FileResourceCreationException;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.util.FileUtils;
import org.linuxstuff.mojo.licensing.FileUtil;
import org.linuxstuff.mojo.licensing.model.ArtifactWithLicenses;

@XStreamAlias(value="licensing")
public class LicensingReport {
    private static final String LINE = "------------------------------------------------------------------------------";
    private static final String FILE_ENCODING = "UTF-8";
    @XStreamAlias(value="disliked-licenses")
    @XStreamAsAttribute
    long dislikedArtifactsCount;
    @XStreamAlias(value="missing-licenses")
    @XStreamAsAttribute
    long missingLicensesCount;
    @XStreamAlias(value="licensing-check")
    @XStreamAsAttribute
    boolean passing = true;
    @XStreamAlias(value="artifacts")
    private Set<ArtifactWithLicenses> licensedArtifacts = new HashSet<ArtifactWithLicenses>();
    @XStreamAlias(value="license-missing")
    private Set<ArtifactWithLicenses> licenseMissing = new HashSet<ArtifactWithLicenses>();
    @XStreamAlias(value="disliked-artifacts")
    private Set<ArtifactWithLicenses> dislikedArtifacts = new HashSet<ArtifactWithLicenses>();

    private void updatePassing() {
        this.passing = this.licenseMissing.isEmpty() && this.dislikedArtifacts.isEmpty();
    }

    public void addLicensedArtifact(ArtifactWithLicenses artifact) {
        this.licensedArtifacts.add(artifact);
    }

    public void addMissingLicense(ArtifactWithLicenses artifact) {
        this.licenseMissing.add(artifact);
        this.missingLicensesCount = this.licenseMissing.size();
        this.updatePassing();
    }

    public void addDislikedArtifact(ArtifactWithLicenses artifact) {
        this.dislikedArtifacts.add(artifact);
        this.dislikedArtifactsCount = this.dislikedArtifacts.size();
        this.updatePassing();
    }

    public Set<ArtifactWithLicenses> getLicensedArtifacts() {
        return this.licensedArtifacts;
    }

    public Set<ArtifactWithLicenses> getLicenseMissing() {
        return this.licenseMissing;
    }

    public Set<ArtifactWithLicenses> getDislikedArtifacts() {
        return this.dislikedArtifacts;
    }

    public void combineWith(LicensingReport artifactReport) {
        for (ArtifactWithLicenses artifact : artifactReport.getDislikedArtifacts()) {
            this.addDislikedArtifact(artifact);
        }
        for (ArtifactWithLicenses artifact : artifactReport.getLicensedArtifacts()) {
            this.addLicensedArtifact(artifact);
        }
        for (ArtifactWithLicenses artifact : artifactReport.getLicenseMissing()) {
            this.addMissingLicense(artifact);
        }
    }

    public void writeReport(File file) throws MojoExecutionException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.processAnnotations(LicensingReport.class);
        xstream.processAnnotations(ArtifactWithLicenses.class);
        FileOutputStream fos = null;
        try {
            FileUtil.createNewFile(file);
            fos = new FileOutputStream(file);
            xstream.toXML((Object)this, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure while creating new file " + file, (Exception)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Error while closing file " + file, (Exception)e);
                }
            }
        }
    }

    public void writeTextReport(File file, ResourceManager locator, String prependText, String appendText, boolean includeDualList, boolean includeFullLicense) throws MojoExecutionException {
        PrintWriter writer = null;
        try {
            File prefixResource = this.getTextResourceFile(locator, prependText);
            File postfixResource = this.getTextResourceFile(locator, appendText);
            FileUtil.createNewFile(file);
            writer = new PrintWriter(file, FILE_ENCODING);
            this.writeToFile(prefixResource, writer);
            this.generateTextReport(writer, locator, includeDualList, includeFullLicense);
            this.writeToFile(postfixResource, writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failure while creating new file " + file, (Exception)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private File getTextResourceFile(ResourceManager locator, String fileName) throws MojoExecutionException {
        File textResource;
        if (fileName == null || "".equals(fileName)) {
            return null;
        }
        try {
            textResource = locator.getResourceAsFile(fileName);
        }
        catch (ResourceNotFoundException e) {
            throw new MojoExecutionException("File not found", (Exception)((Object)e));
        }
        catch (FileResourceCreationException e) {
            throw new MojoExecutionException("Could not create file resource.", (Exception)((Object)e));
        }
        return textResource;
    }

    private void writeToFile(File fromFile, PrintWriter writer) throws IOException {
        if (fromFile != null) {
            String[] lines;
            for (String line : lines = FileUtils.fileRead((File)fromFile, (String)FILE_ENCODING).split("\n")) {
                writer.println(line);
            }
            writer.println();
        }
    }

    private void generateTextReport(PrintWriter writer, ResourceManager locator, boolean includeDualList, boolean includeFullLicense) throws IOException, MojoExecutionException {
        TreeMap<String, TreeSet<String>> artifactsPerLicense = new TreeMap<String, TreeSet<String>>();
        TreeMap<String, TreeSet<String>> multiLicensed = new TreeMap<String, TreeSet<String>>();
        for (ArtifactWithLicenses artifactWithLicenses : this.getLicensedArtifacts()) {
            String artifactName = artifactWithLicenses.getName();
            Set<String> licenses = artifactWithLicenses.getLicenses();
            for (String license : licenses) {
                TreeSet<String> artifacts = (TreeSet<String>)artifactsPerLicense.get(license);
                if (artifacts == null) {
                    artifacts = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    artifactsPerLicense.put(license, artifacts);
                }
                artifacts.add(artifactName);
                if (licenses.size() <= 1) continue;
                TreeSet<String> artifactLicenses = (TreeSet<String>)multiLicensed.get(artifactName);
                if (artifactLicenses == null) {
                    artifactLicenses = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                    multiLicensed.put(artifactName, artifactLicenses);
                }
                artifactLicenses.add(license);
            }
        }
        if (!includeFullLicense) {
            writer.println("Third-party licenses");
            writer.println("--------------------");
        }
        for (Map.Entry entry : artifactsPerLicense.entrySet()) {
            if (includeFullLicense) {
                writer.println(LINE);
            } else {
                writer.println();
            }
            writer.println((String)entry.getKey());
            for (String artifactName : (SortedSet)entry.getValue()) {
                writer.println("  " + artifactName);
            }
            if (!includeFullLicense) continue;
            writer.println("------------------------------------------------------------------------------\n");
            this.writeToFile(this.getTextResourceFile(locator, (String)entry.getKey()), writer);
            writer.println();
        }
        writer.println();
        if (multiLicensed.size() > 0) {
            writer.println("Dependencies with multiple licenses");
            writer.println("-----------------------------------");
            for (Map.Entry entry : multiLicensed.entrySet()) {
                writer.println();
                writer.println((String)entry.getKey());
                for (String licenseName : (SortedSet)entry.getValue()) {
                    writer.println("  " + licenseName);
                }
            }
            writer.println();
        }
    }
}

