/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.linuxstuff.mojo.licensing.AbstractLicensingMojo;
import org.linuxstuff.mojo.licensing.model.ArtifactWithLicenses;
import org.linuxstuff.mojo.licensing.model.LicensingReport;

public class CheckMojo
extends AbstractLicensingMojo {
    protected boolean failIfMissing;
    protected boolean failIfDisliked;
    protected boolean includeOnlyLikedInReport;
    protected boolean plainTextReport;
    protected String listReport;
    protected String listPrependText;
    protected String prependText;
    protected String appendText;
    protected String checkExistingNoticeFile;
    protected String checkExistingLicensesFile;
    protected boolean overwrite;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"licensing.skip=true, not doing anything.");
            return;
        }
        this.readLicensingRequirements();
        LicensingReport report = this.generateReport(this.project);
        File file = new File(this.project.getBuild().getDirectory(), this.thirdPartyLicensingFilename);
        if (this.plainTextReport) {
            report.writeTextReport(file, this.locator, this.prependText, this.appendText, true, false);
            this.compareToExistingFile(file, this.checkExistingNoticeFile);
            if (this.listReport != null) {
                file = new File(this.project.getBuild().getDirectory(), this.listReport);
                report.writeTextReport(file, this.locator, this.listPrependText, null, false, true);
                this.compareToExistingFile(file, this.checkExistingLicensesFile);
            }
        } else {
            report.writeReport(file);
        }
        this.checkForFailure(report);
    }

    private void compareToExistingFile(File file, String existingFileName) throws MojoExecutionException {
        if (existingFileName != null) {
            File existingFile = FileUtils.getFile((String)existingFileName);
            try {
                if (!FileUtils.contentEquals((File)file, (File)existingFile)) {
                    this.generatedAndExistingDiffer(file, existingFile);
                } else {
                    this.getLog().info((CharSequence)("File confirmed: " + existingFileName));
                }
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Could not compare files.", (Exception)ioe);
            }
        }
    }

    protected void generatedAndExistingDiffer(File file, File existingFile) throws MojoExecutionException {
        if (this.overwrite) {
            try {
                this.getLog().info((CharSequence)("Replacing " + existingFile));
                FileUtils.rename((File)file, (File)existingFile);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not overwrite the existing file.\nGenerated: " + file + "\n" + "Existing: " + existingFile);
            }
        } else {
            throw new MojoExecutionException("Generated file differs from the existing file.\nGenerated: " + file + "\n" + "Existing: " + existingFile);
        }
    }

    protected LicensingReport generateReport(MavenProject project) {
        Set<String> licenses;
        ArtifactWithLicenses entry;
        LicensingReport aReport = new LicensingReport();
        Collection<MavenProject> projects = this.getProjectDependencies(project);
        for (MavenProject mavenProject : projects) {
            entry = new ArtifactWithLicenses();
            entry.setArtifactId(mavenProject.getId());
            entry.setName(mavenProject.getName());
            licenses = this.collectLicensesForMavenProject(mavenProject);
            if (licenses.isEmpty()) {
                this.getLog().warn((CharSequence)("Licensing: The artifact " + entry.getArtifactId() + " has no license specified."));
                aReport.addMissingLicense(entry);
                continue;
            }
            for (String license : licenses) {
                if (this.includeOnlyLikedInReport && this.licensingRequirements.containsLikedLicenses()) {
                    if (!this.licensingRequirements.isLikedLicense(license)) continue;
                    entry.addLicense(license);
                    continue;
                }
                entry.addLicense(license);
            }
            this.licensingRequirements.normalizeLicenses(entry);
            if (this.isDisliked(entry)) {
                this.getLog().warn((CharSequence)("Licensing: The artifact " + entry.getArtifactId() + " is only under disliked licenses: " + licenses));
                aReport.addDislikedArtifact(entry);
                continue;
            }
            aReport.addLicensedArtifact(entry);
        }
        for (ArtifactWithLicenses artifactWithLicenses : this.licensingRequirements.getMissingArtifacts()) {
            entry = new ArtifactWithLicenses(artifactWithLicenses.getArtifactId(), artifactWithLicenses.getName());
            licenses = artifactWithLicenses.getLicenses();
            if (licenses.isEmpty()) {
                this.getLog().warn((CharSequence)("Licensing: The artifact " + entry.getArtifactId() + " has no license specified."));
                aReport.addMissingLicense(entry);
                continue;
            }
            for (String license : licenses) {
                String correct = this.licensingRequirements.getCorrectLicenseName(license);
                if (this.includeOnlyLikedInReport && this.licensingRequirements.containsLikedLicenses()) {
                    if (!this.licensingRequirements.isLikedLicense(correct)) continue;
                    entry.addLicense(correct);
                    continue;
                }
                entry.addLicense(correct);
            }
            this.licensingRequirements.normalizeLicenses(entry);
            if (this.isDisliked(entry)) {
                this.getLog().warn((CharSequence)("Licensing: The artifact " + entry.getArtifactId() + " is only under disliked licenses: " + licenses));
                aReport.addDislikedArtifact(entry);
                continue;
            }
            aReport.addLicensedArtifact(entry);
        }
        return aReport;
    }

    protected void checkForFailure(LicensingReport report) throws MojoFailureException {
        long disliked = report.getDislikedArtifacts().size();
        long missing = report.getLicenseMissing().size();
        if (disliked > 0L && missing > 0L && this.failIfDisliked && this.failIfMissing) {
            throw new MojoFailureException("This project has " + disliked + " disliked artifact" + (disliked == 1L ? "" : "s") + " and " + missing + " artifact" + (missing == 1L ? "" : "s") + " missing licensing information.");
        }
        if (missing > 0L && this.failIfMissing) {
            throw new MojoFailureException("This project has " + missing + " artifact" + (missing == 1L ? "" : "s") + " missing licensing information.");
        }
        if (disliked > 0L && this.failIfDisliked) {
            throw new MojoFailureException("This project has " + disliked + " disliked artifact" + (disliked == 1L ? "" : "s") + ".");
        }
    }
}

