/*
 * Decompiled with CFR 0.152.
 */
package org.linuxstuff.mojo.licensing;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.License;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.resource.ResourceManager;
import org.linuxstuff.mojo.licensing.DependenciesTool;
import org.linuxstuff.mojo.licensing.MavenProjectDependenciesConfigurator;
import org.linuxstuff.mojo.licensing.model.ArtifactWithLicenses;
import org.linuxstuff.mojo.licensing.model.CoalescedLicense;
import org.linuxstuff.mojo.licensing.model.LicensingRequirements;

public abstract class AbstractLicensingMojo
extends AbstractMojo
implements MavenProjectDependenciesConfigurator {
    protected ResourceManager locator;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    protected MavenProject project;
    protected DependenciesTool dependenciesTool;
    protected String excludedScopes;
    protected String includedScopes;
    protected String excludedGroups;
    protected String thirdPartyLicensingFilename;
    protected String aggregatedThirdPartyLicensingFilename;
    protected String includedGroups;
    protected String excludedArtifacts;
    protected String includedArtifacts;
    protected boolean includeTransitiveDependencies;
    protected boolean skip;
    protected List<String> licensingRequirementFiles;
    protected LicensingRequirements licensingRequirements = new LicensingRequirements();

    protected Collection<MavenProject> getProjectDependencies(MavenProject aProject) {
        this.getLog().debug((CharSequence)("Getting dependencies for project: " + aProject.getId()));
        SortedMap<String, MavenProject> dependencies = this.dependenciesTool.loadProjectDependencies(aProject, this, this.localRepository, this.remoteRepositories, null);
        this.getLog().debug((CharSequence)("Dependencies found for project: " + dependencies.values().size()));
        return dependencies.values();
    }

    protected void readLicensingRequirements() throws MojoExecutionException {
        XStream xstream = new XStream((HierarchicalStreamDriver)new StaxDriver());
        xstream.processAnnotations(LicensingRequirements.class);
        xstream.processAnnotations(ArtifactWithLicenses.class);
        xstream.processAnnotations(CoalescedLicense.class);
        if (this.licensingRequirementFiles == null) {
            this.getLog().debug((CharSequence)"No licensing requirement files specified.");
            return;
        }
        ArrayList<LicensingRequirements> requirements = new ArrayList<LicensingRequirements>();
        for (String requirementsFile : this.licensingRequirementFiles) {
            try {
                requirements.add((LicensingRequirements)xstream.fromXML(this.locator.getResourceAsInputStream(requirementsFile)));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Could not read licensing requirements file: " + requirementsFile, e);
            }
        }
        this.licensingRequirements = this.mergeLicenseRequirements(requirements);
    }

    private LicensingRequirements mergeLicenseRequirements(List<LicensingRequirements> requirements) {
        LicensingRequirements merged = new LicensingRequirements();
        for (LicensingRequirements req : requirements) {
            merged.combineWith(req);
        }
        return merged;
    }

    protected boolean isDisliked(MavenProject mavenProject) {
        if (!this.isDislikable(mavenProject.getId())) {
            return false;
        }
        Set<String> licenses = this.collectLicensesForMavenProject(mavenProject);
        return this.checkDisliked(licenses);
    }

    private boolean isDislikable(String id) {
        boolean dislikable = true;
        if (!this.licensingRequirements.containsDislikedLicenses() && !this.licensingRequirements.containsLikedLicenses()) {
            dislikable = false;
        }
        if (this.licensingRequirements.isExemptFromDislike(id)) {
            dislikable = false;
        }
        return dislikable;
    }

    private boolean checkDisliked(Set<String> licenses) {
        if (this.licensingRequirements.containsLikedLicenses()) {
            for (String license : licenses) {
                if (!this.licensingRequirements.isLikedLicense(license)) continue;
                return false;
            }
            return true;
        }
        for (String license : licenses) {
            if (this.licensingRequirements.isDislikedLicense(license)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDisliked(ArtifactWithLicenses artifactWithLicenses) {
        if (!this.isDislikable(artifactWithLicenses.getArtifactId())) {
            return false;
        }
        Set<String> licenses = artifactWithLicenses.getLicenses();
        return this.checkDisliked(licenses);
    }

    protected boolean hasLicense(MavenProject mavenProject) {
        return !this.collectLicensesForMavenProject(mavenProject).isEmpty();
    }

    protected Set<String> collectLicensesForMavenProject(MavenProject mavenProject) {
        HashSet<String> licenses = new HashSet<String>();
        if (mavenProject.getLicenses() != null && mavenProject.getLicenses().size() > 0) {
            this.getLog().debug((CharSequence)("Licensing: " + mavenProject.getId() + " has licensing information in it."));
            List embeddedLicenses = mavenProject.getLicenses();
            for (License license : embeddedLicenses) {
                if (license.getName() == null) continue;
                licenses.add(this.licensingRequirements.getCorrectLicenseName(license.getName()));
            }
        } else {
            Set<String> hardcodedLicenses = this.licensingRequirements.getLicenseNames(mavenProject.getId());
            for (String license : hardcodedLicenses) {
                licenses.add(this.licensingRequirements.getCorrectLicenseName(license));
            }
        }
        return licenses;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    @Override
    public List<String> getIncludedScopes() {
        String[] split = this.includedScopes == null ? new String[]{} : this.includedScopes.split(",");
        return Arrays.asList(split);
    }

    @Override
    public List<String> getExcludedScopes() {
        String[] split = this.excludedScopes == null ? new String[]{} : this.excludedScopes.split(",");
        return Arrays.asList(split);
    }

    @Override
    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    @Override
    public String getIncludedGroups() {
        return this.includedGroups;
    }

    @Override
    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    @Override
    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }
}

